/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors;

import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.session.Session;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.AbstractIoTDB;
import org.apache.nifi.processors.model.DatabaseSchema;
import org.apache.nifi.processors.model.ValidationResult;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

@Tags(value={"IoT", "Timeseries"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Read input FlowFile Records and write to Apache IoTDB")
public class PutIoTDBRecord
extends AbstractIoTDB {
    static final PropertyDescriptor PREFIX = new PropertyDescriptor.Builder().name("Prefix").description("The Timeseries prefix where records will be stored. The prefix must begin with [root] and end with [.]").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    static final PropertyDescriptor TIME_FIELD = new PropertyDescriptor.Builder().name("Time Field").description("The name of field containing the timestamp in FlowFile Records").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("Time").required(true).build();
    static final PropertyDescriptor ALIGNED = new PropertyDescriptor.Builder().name("Aligned").description("Whether to use the Apache IoTDB Aligned Timeseries interface").allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).defaultValue(Boolean.FALSE.toString()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    static final PropertyDescriptor MAX_ROW_NUMBER = new PropertyDescriptor.Builder().name("Max Row Number").description("Maximum row number of each Apache IoTDB Tablet").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).defaultValue("1024").build();
    static final PropertyDescriptor RECORD_READER_FACTORY = new PropertyDescriptor.Builder().name("Record Reader").description("Record Reader used for parsing the incoming FlowFiles and determining the schema").identifiesControllerService(RecordReaderFactory.class).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    static final PropertyDescriptor SCHEMA_TEMPLATE = new PropertyDescriptor.Builder().name("Schema Template").description("Apache IoTDB Schema Template defined using JSON. The Processor will infer the IoTDB Schema when this property is not configured. See the Apache IoTDB Documentation for more details: https://iotdb.apache.org/UserGuide/Master/Ecosystem-Integration/NiFi-IoTDB.html").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    private static final String ROOT_PREFIX = "root.";

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        propertyDescriptors.add(PREFIX);
        propertyDescriptors.add(TIME_FIELD);
        propertyDescriptors.add(ALIGNED);
        propertyDescriptors.add(MAX_ROW_NUMBER);
        propertyDescriptors.add(RECORD_READER_FACTORY);
        propertyDescriptors.add(SCHEMA_TEMPLATE);
        return Collections.unmodifiableList(propertyDescriptors);
    }

    public void onTrigger(ProcessContext processContext, ProcessSession processSession) throws ProcessException {
        FlowFile flowFile = processSession.get();
        if (flowFile == null) {
            return;
        }
        String prefix = processContext.getProperty(PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        if (!prefix.startsWith(ROOT_PREFIX) || !prefix.endsWith(".")) {
            this.getLogger().error("Prefix does not begin with [root] and end with [.] {}", new Object[]{flowFile});
            processSession.transfer(flowFile, REL_FAILURE);
            return;
        }
        String schemaProperty = processContext.getProperty(SCHEMA_TEMPLATE).evaluateAttributeExpressions(flowFile).getValue();
        boolean aligned = processContext.getProperty(ALIGNED).evaluateAttributeExpressions(flowFile).asBoolean();
        int maxRowNumber = processContext.getProperty(MAX_ROW_NUMBER).evaluateAttributeExpressions(flowFile).asInteger();
        String timeField = processContext.getProperty(TIME_FIELD).evaluateAttributeExpressions(flowFile).getValue();
        RecordReaderFactory recordParserFactory = (RecordReaderFactory)processContext.getProperty(RECORD_READER_FACTORY).asControllerService(RecordReaderFactory.class);
        try (InputStream inputStream = processSession.read(flowFile);
             RecordReader recordReader = recordParserFactory.createRecordReader(flowFile, inputStream, this.getLogger());){
            Record record;
            DatabaseSchema schema = this.getSchema(timeField, schemaProperty, recordReader);
            Map<String, Tablet> tablets = this.generateTablets(schema, prefix, maxRowNumber);
            while ((record = recordReader.nextRecord()) != null) {
                long timestamp = this.getTimestamp(timeField, record);
                boolean filled = false;
                for (Map.Entry<String, Tablet> entry : tablets.entrySet()) {
                    Tablet tablet2 = entry.getValue();
                    int rowIndex = tablet2.getRowSize() + 1;
                    tablet2.addTimestamp(rowIndex, timestamp);
                    List measurements = tablet2.getSchemas();
                    for (IMeasurementSchema measurement : measurements) {
                        String id = measurement.getMeasurementName();
                        TSDataType type = measurement.getType();
                        Object value = this.getTypedValue(record.getValue(id), type);
                        tablet2.addValue(id, rowIndex, value);
                    }
                    filled = tablet2.getRowSize() == tablet2.getMaxRowNumber();
                }
                if (!filled) continue;
                if (aligned) {
                    ((Session)this.session.get()).insertAlignedTablets(tablets);
                } else {
                    ((Session)this.session.get()).insertTablets(tablets);
                }
                tablets.values().forEach(Tablet::reset);
            }
            AtomicBoolean remaining = new AtomicBoolean(false);
            tablets.forEach((device, tablet) -> {
                if (!remaining.get() && tablet.getRowSize() != 0) {
                    remaining.set(true);
                }
            });
            if (remaining.get()) {
                if (aligned) {
                    ((Session)this.session.get()).insertAlignedTablets(tablets);
                } else {
                    ((Session)this.session.get()).insertTablets(tablets);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Processing failed {}", new Object[]{flowFile, e});
            processSession.transfer(flowFile, REL_FAILURE);
            return;
        }
        processSession.transfer(flowFile, REL_SUCCESS);
    }

    private DatabaseSchema getSchema(String timeField, String property, RecordReader recordReader) throws MalformedRecordException, IOException {
        ValidationResult result;
        ValidationResult validationResult = result = property == null ? this.validateSchema(timeField, recordReader.getSchema()) : this.validateSchemaAttribute(property);
        if (result.isValid()) {
            return property == null ? this.convertSchema(timeField, recordReader.getSchema()) : (DatabaseSchema)mapper.readValue(property, DatabaseSchema.class);
        }
        String message = String.format("Schema validation failed: %s", result.getMessage());
        throw new IllegalArgumentException(message);
    }

    private long getTimestamp(String timeField, Record record) {
        Object time;
        Object object = time = record.getValue(timeField);
        int n = 0;
        long timestamp = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Timestamp.class, Time.class, Date.class, Long.class}, (Object)object, n)) {
            case 0 -> {
                Timestamp temp = (Timestamp)object;
                yield temp.getTime();
            }
            case 1 -> {
                Time temp = (Time)object;
                yield temp.getTime();
            }
            case 2 -> {
                Date temp = (Date)object;
                yield temp.getTime();
            }
            case 3 -> {
                Long number = (Long)object;
                yield number;
            }
            default -> throw new IllegalArgumentException(String.format("Unexpected Time Field Type: %s", time));
        };
        return timestamp;
    }

    private Object getTypedValue(Object value, TSDataType type) {
        Object typedValue;
        if (value == null) {
            typedValue = null;
        } else {
            try {
                typedValue = this.convertType(value, type);
            }
            catch (Exception e) {
                String message = String.format("Value [%s] cannot be converted to the type [%s]", value, type);
                throw new IllegalArgumentException(message, e);
            }
        }
        return typedValue;
    }
}

