/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.processors.model.DatabaseField;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class DatabaseSchema {
    private final Map<String, DatabaseField> fieldMap = new LinkedHashMap<String, DatabaseField>();
    private final List<String> fieldNames = new ArrayList<String>();

    @JsonCreator
    public DatabaseSchema(@JsonProperty(value="fields") List<DatabaseField> fields) {
        fields.forEach(field -> {
            this.fieldMap.put(field.getTsName(), (DatabaseField)field);
            this.fieldNames.add(field.getTsName());
        });
    }

    public List<String> getFieldNames(String prefix) {
        return this.fieldNames.stream().map(field -> prefix + field).collect(Collectors.toList());
    }

    public List<TSDataType> getDataTypes() {
        return this.fieldMap.values().stream().map(DatabaseField::getDataType).collect(Collectors.toList());
    }

    public List<TSEncoding> getEncodingTypes() {
        return this.fieldMap.values().stream().map(DatabaseField::getEncoding).collect(Collectors.toList());
    }

    public List<CompressionType> getCompressionTypes() {
        return this.fieldMap.values().stream().map(DatabaseField::getCompressionType).collect(Collectors.toList());
    }

    public TSDataType getDataType(String fieldName) {
        return this.fieldMap.get(fieldName).getDataType();
    }

    public TSEncoding getEncodingType(String fieldName) {
        return this.fieldMap.get(fieldName).getEncoding();
    }

    public CompressionType getCompressionType(String fieldName) {
        return this.fieldMap.get(fieldName).getCompressionType();
    }
}

