/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.record;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Types;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.RecordField;

public class DelegatedRecord
implements Record {
    private final org.apache.nifi.serialization.record.Record record;
    private final Types.StructType struct;

    public DelegatedRecord(org.apache.nifi.serialization.record.Record record, Types.StructType struct) {
        this.record = Objects.requireNonNull(record);
        this.struct = Objects.requireNonNull(struct);
    }

    public Types.StructType struct() {
        return this.struct;
    }

    public Object getField(String fieldName) {
        return this.record.getValue(fieldName);
    }

    public void setField(String fieldName, Object fieldValue) {
        this.record.setValue(fieldName, fieldValue);
    }

    public Object get(int position) {
        RecordField recordField = this.record.getSchema().getField(position);
        return this.record.getValue(recordField);
    }

    public Record copy() {
        return this.copy(Collections.emptyMap());
    }

    public Record copy(Map<String, Object> overrides) {
        Map values = this.record.toMap();
        values.putAll(overrides);
        MapRecord mapRecord = new MapRecord(this.record.getSchema(), values);
        return new DelegatedRecord((org.apache.nifi.serialization.record.Record)mapRecord, this.struct);
    }

    public int size() {
        return this.record.getSchema().getFieldCount();
    }

    public <T> T get(int position, Class<T> valueClass) {
        Object value = this.get(position);
        if (value == null || valueClass.isInstance(value)) {
            return valueClass.cast(value);
        }
        throw new IllegalStateException(String.format("Field [%d] value not an instance of [%s]", position, valueClass));
    }

    public <T> void set(int position, T value) {
        RecordField recordField = this.record.getSchema().getField(position);
        this.record.setValue(recordField, value);
    }

    public boolean equals(Object other) {
        boolean equals;
        if (other instanceof DelegatedRecord) {
            DelegatedRecord otherRecord = (DelegatedRecord)other;
            equals = this.record.equals((Object)otherRecord.record);
        } else {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        return this.record.hashCode();
    }
}

