/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.iceberg.PutIcebergRecord;

class TableIdentifierFlowFileFilter
implements FlowFileFilter {
    private static final int MAXIMUM_FLOW_FILES = 1000;
    private final ProcessContext context;
    private int flowFilesAccepted;
    private long flowFileBytesAccepted;
    private final long maximumBytes;
    private TableIdentifier tableIdentifier;

    TableIdentifierFlowFileFilter(ProcessContext context, long maximumBytes) {
        this.context = context;
        this.maximumBytes = maximumBytes;
    }

    public FlowFileFilter.FlowFileFilterResult filter(FlowFile flowFile) {
        FlowFileFilter.FlowFileFilterResult filterResult;
        TableIdentifier flowFileTableIdentifier = this.getFlowFileTableIdentifier(flowFile);
        if (this.tableIdentifier == null) {
            this.tableIdentifier = flowFileTableIdentifier;
        }
        if (this.tableIdentifier.equals((Object)flowFileTableIdentifier)) {
            long flowFileSize = flowFile.getSize();
            if (flowFileSize >= this.maximumBytes) {
                filterResult = FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_TERMINATE;
            } else {
                ++this.flowFilesAccepted;
                this.flowFileBytesAccepted += flowFileSize;
                filterResult = this.flowFileBytesAccepted >= this.maximumBytes ? FlowFileFilter.FlowFileFilterResult.REJECT_AND_TERMINATE : (this.flowFilesAccepted == 1000 ? FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_TERMINATE : FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE);
            }
        } else {
            filterResult = FlowFileFilter.FlowFileFilterResult.REJECT_AND_CONTINUE;
        }
        return filterResult;
    }

    TableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    private TableIdentifier getFlowFileTableIdentifier(FlowFile flowFile) {
        String namespace = this.context.getProperty(PutIcebergRecord.NAMESPACE).evaluateAttributeExpressions(flowFile).getValue();
        String tableName = this.context.getProperty(PutIcebergRecord.TABLE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        Namespace icebergNamespace = Namespace.of((String[])new String[]{namespace});
        return TableIdentifier.of((Namespace)icebergNamespace, (String)tableName);
    }
}

