/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.iceberg.converter;

import java.io.Serializable;
import java.time.ZoneId;
import javax.annotation.Nullable;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;

public class RecordFieldGetter {
    public static FieldGetter createFieldGetter(DataType dataType, String fieldName, boolean isNullable) {
        FieldGetter fieldGetter;
        switch (dataType.getFieldType()) {
            case STRING: {
                fieldGetter = record -> record.getAsString(fieldName);
                break;
            }
            case CHAR: {
                fieldGetter = record -> DataTypeUtils.toCharacter((Object)record.getValue(fieldName), (String)fieldName);
                break;
            }
            case BOOLEAN: {
                fieldGetter = record -> record.getAsBoolean(fieldName);
                break;
            }
            case DECIMAL: {
                fieldGetter = record -> DataTypeUtils.toBigDecimal((Object)record.getValue(fieldName), (String)fieldName);
                break;
            }
            case BYTE: {
                fieldGetter = record -> DataTypeUtils.toByte((Object)record.getValue(fieldName), (String)fieldName);
                break;
            }
            case SHORT: {
                fieldGetter = record -> DataTypeUtils.toShort((Object)record.getValue(fieldName), (String)fieldName);
                break;
            }
            case INT: {
                fieldGetter = record -> record.getAsInt(fieldName);
                break;
            }
            case DATE: {
                fieldGetter = record -> DataTypeUtils.toLocalDate((Object)record.getValue(fieldName), () -> DataTypeUtils.getDateTimeFormatter((String)dataType.getFormat(), (ZoneId)ZoneId.systemDefault()), (String)fieldName);
                break;
            }
            case TIME: {
                fieldGetter = record -> DataTypeUtils.toTime((Object)record.getValue(fieldName), () -> DataTypeUtils.getDateFormat((String)dataType.getFormat()), (String)fieldName);
                break;
            }
            case LONG: {
                fieldGetter = record -> record.getAsLong(fieldName);
                break;
            }
            case BIGINT: {
                fieldGetter = record -> DataTypeUtils.toBigInt((Object)record.getValue(fieldName), (String)fieldName);
                break;
            }
            case FLOAT: {
                fieldGetter = record -> record.getAsFloat(fieldName);
                break;
            }
            case DOUBLE: {
                fieldGetter = record -> record.getAsDouble(fieldName);
                break;
            }
            case TIMESTAMP: {
                fieldGetter = record -> DataTypeUtils.toTimestamp((Object)record.getValue(fieldName), () -> DataTypeUtils.getDateFormat((String)dataType.getFormat()), (String)fieldName);
                break;
            }
            case UUID: {
                fieldGetter = record -> DataTypeUtils.toUUID((Object)record.getValue(fieldName));
                break;
            }
            case ARRAY: {
                fieldGetter = record -> DataTypeUtils.toArray((Object)record.getValue(fieldName), (String)fieldName, (DataType)((ArrayDataType)dataType).getElementType());
                break;
            }
            case MAP: {
                fieldGetter = record -> DataTypeUtils.toMap((Object)record.getValue(fieldName), (String)fieldName);
                break;
            }
            case RECORD: {
                fieldGetter = record -> record.getAsRecord(fieldName, ((RecordDataType)dataType).getChildSchema());
                break;
            }
            case CHOICE: {
                fieldGetter = record -> {
                    ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
                    Object value = record.getValue(fieldName);
                    DataType chosenDataType = DataTypeUtils.chooseDataType((Object)value, (ChoiceDataType)choiceDataType);
                    if (chosenDataType == null) {
                        throw new IllegalTypeConversionException(String.format("Cannot convert value [%s] of type %s for field %s to any of the following available Sub-Types for a Choice: %s", value, value.getClass(), fieldName, choiceDataType.getPossibleSubTypes()));
                    }
                    return DataTypeUtils.convertType((Object)record.getValue(fieldName), (DataType)chosenDataType, (String)fieldName);
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field type: " + dataType.getFieldType());
            }
        }
        if (!isNullable) {
            return fieldGetter;
        }
        return record -> {
            if (record.getValue(fieldName) == null) {
                return null;
            }
            return fieldGetter.getFieldOrNull(record);
        };
    }

    public static interface FieldGetter
    extends Serializable {
        @Nullable
        public Object getFieldOrNull(Record var1);
    }
}

