/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.comparison;

import java.util.Collection;
import java.util.Map;
import org.apache.nifi.hl7.model.HL7Field;
import org.apache.nifi.hl7.query.evaluator.BooleanEvaluator;
import org.apache.nifi.hl7.query.evaluator.Evaluator;

public abstract class AbstractComparisonEvaluator
extends BooleanEvaluator {
    private final Evaluator<?> lhs;
    private final Evaluator<?> rhs;

    public AbstractComparisonEvaluator(Evaluator<?> lhs, Evaluator<?> rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public final Boolean evaluate(Map<String, Object> objectMap) {
        Object lhsValue = this.lhs.evaluate(objectMap);
        if (lhsValue == null) {
            return false;
        }
        Object rhsValue = this.rhs.evaluate(objectMap);
        if (rhsValue == null) {
            return false;
        }
        return this.compareRaw(lhsValue, rhsValue);
    }

    private Boolean compareRaw(Object lhsValue, Object rhsValue) {
        if (lhsValue == null || rhsValue == null) {
            return false;
        }
        if (lhsValue instanceof HL7Field) {
            lhsValue = ((HL7Field)lhsValue).getValue();
        }
        if (rhsValue instanceof HL7Field) {
            rhsValue = ((HL7Field)rhsValue).getValue();
        }
        if (lhsValue == null || rhsValue == null) {
            return false;
        }
        if (lhsValue instanceof Collection && rhsValue instanceof Collection) {
            return false;
        }
        if (lhsValue instanceof Collection) {
            for (Object lhsObject : (Collection)lhsValue) {
                if (!this.compareRaw(lhsObject, rhsValue).booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (rhsValue instanceof Collection) {
            for (Object rhsObject : (Collection)rhsValue) {
                if (!this.compareRaw(rhsObject, lhsValue).booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (lhsValue != null && rhsValue != null && this.compare(lhsValue, rhsValue)) {
            return true;
        }
        return false;
    }

    protected abstract boolean compare(Object var1, Object var2);
}

