/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.hl7.model.HL7Message;
import org.apache.nifi.hl7.query.Declaration;
import org.apache.nifi.hl7.query.QueryResult;
import org.apache.nifi.hl7.query.Selection;
import org.apache.nifi.hl7.query.antlr.HL7QueryLexer;
import org.apache.nifi.hl7.query.antlr.HL7QueryParser;
import org.apache.nifi.hl7.query.evaluator.BooleanEvaluator;
import org.apache.nifi.hl7.query.evaluator.Evaluator;
import org.apache.nifi.hl7.query.evaluator.IntegerEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.EqualsEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.GreaterThanEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.GreaterThanOrEqualEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.IsNullEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.LessThanEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.LessThanOrEqualEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.NotEqualsEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.NotEvaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.NotNullEvaluator;
import org.apache.nifi.hl7.query.evaluator.literal.IntegerLiteralEvaluator;
import org.apache.nifi.hl7.query.evaluator.literal.StringLiteralEvaluator;
import org.apache.nifi.hl7.query.evaluator.logic.AndEvaluator;
import org.apache.nifi.hl7.query.evaluator.logic.OrEvaluator;
import org.apache.nifi.hl7.query.evaluator.message.DeclaredReferenceEvaluator;
import org.apache.nifi.hl7.query.evaluator.message.DotEvaluator;
import org.apache.nifi.hl7.query.evaluator.message.MessageEvaluator;
import org.apache.nifi.hl7.query.evaluator.message.SegmentEvaluator;
import org.apache.nifi.hl7.query.exception.HL7QueryParsingException;
import org.apache.nifi.hl7.query.result.MissedResult;
import org.apache.nifi.hl7.query.result.StandardQueryResult;

public class HL7Query {
    private final Tree tree;
    private final String query;
    private final Set<Declaration> declarations = new HashSet<Declaration>();
    private final List<Selection> selections;
    private final BooleanEvaluator whereEvaluator;

    private HL7Query(Tree tree, String query) {
        this.tree = tree;
        this.query = query;
        List<Selection> select = null;
        BooleanEvaluator where = null;
        block5: for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree child = tree.getChild(i);
            switch (child.getType()) {
                case 10: {
                    this.processDeclare(child);
                    continue block5;
                }
                case 38: {
                    select = this.processSelect(child);
                    continue block5;
                }
                case 42: {
                    where = this.processWhere(child);
                    continue block5;
                }
                default: {
                    throw new HL7QueryParsingException("Found unexpected clause at root level: " + tree.getText());
                }
            }
        }
        this.whereEvaluator = where;
        this.selections = select;
    }

    private void processDeclare(Tree declare) {
        for (int i = 0; i < declare.getChildCount(); ++i) {
            Tree declarationTree = declare.getChild(i);
            final String identifier = declarationTree.getChild(0).getText();
            Tree requiredOrOptionalTree = declarationTree.getChild(1);
            final boolean required = requiredOrOptionalTree.getType() == 34;
            final String segmentName = declarationTree.getChild(2).getText();
            Declaration declaration = new Declaration(){

                @Override
                public String getAlias() {
                    return identifier;
                }

                @Override
                public boolean isRequired() {
                    return required;
                }

                @Override
                public Object getDeclaredValue(HL7Message message) {
                    if (message == null) {
                        return null;
                    }
                    return message.getSegments(segmentName);
                }
            };
            this.declarations.add(declaration);
        }
    }

    private List<Selection> processSelect(Tree select) {
        ArrayList<Selection> selections = new ArrayList<Selection>();
        for (int i = 0; i < select.getChildCount(); ++i) {
            Tree selectable = select.getChild(i);
            String alias = this.getSelectedName(selectable);
            Evaluator<?> selectionEvaluator = this.buildReferenceEvaluator(selectable);
            Selection selection = new Selection(selectionEvaluator, alias);
            selections.add(selection);
        }
        return selections;
    }

    private String getSelectedName(Tree selectable) {
        if (selectable.getChildCount() == 0) {
            return selectable.getText();
        }
        if (selectable.getType() == 11) {
            return this.getSelectedName(selectable.getChild(0)) + "." + this.getSelectedName(selectable.getChild(1));
        }
        return selectable.getChild(selectable.getChildCount() - 1).getText();
    }

    private BooleanEvaluator processWhere(Tree where) {
        return this.buildBooleanEvaluator(where.getChild(0));
    }

    private Evaluator<?> buildReferenceEvaluator(Tree tree) {
        switch (tree.getType()) {
            case 25: {
                return new MessageEvaluator();
            }
            case 37: {
                return new SegmentEvaluator(new StringLiteralEvaluator(tree.getText()));
            }
            case 17: {
                return new DeclaredReferenceEvaluator(new StringLiteralEvaluator(tree.getText()));
            }
            case 11: {
                Tree firstChild = tree.getChild(0);
                Tree secondChild = tree.getChild(1);
                return new DotEvaluator(this.buildReferenceEvaluator(firstChild), this.buildIntegerEvaluator(secondChild));
            }
            case 40: {
                return new StringLiteralEvaluator(tree.getText());
            }
            case 29: {
                return new IntegerLiteralEvaluator(Integer.parseInt(tree.getText()));
            }
        }
        throw new HL7QueryParsingException("Failed to build evaluator for " + tree.getText());
    }

    private IntegerEvaluator buildIntegerEvaluator(Tree tree) {
        if (tree.getType() == 29) {
            return new IntegerLiteralEvaluator(Integer.parseInt(tree.getText()));
        }
        throw new HL7QueryParsingException("Failed to build Integer Evaluator for " + tree.getText());
    }

    private BooleanEvaluator buildBooleanEvaluator(Tree tree) {
        return switch (tree.getType()) {
            case 12 -> new EqualsEvaluator(this.buildReferenceEvaluator(tree.getChild(0)), this.buildReferenceEvaluator(tree.getChild(1)));
            case 27 -> new NotEqualsEvaluator(this.buildReferenceEvaluator(tree.getChild(0)), this.buildReferenceEvaluator(tree.getChild(1)));
            case 16 -> new GreaterThanEvaluator(this.buildReferenceEvaluator(tree.getChild(0)), this.buildReferenceEvaluator(tree.getChild(1)));
            case 24 -> new LessThanEvaluator(this.buildReferenceEvaluator(tree.getChild(0)), this.buildReferenceEvaluator(tree.getChild(1)));
            case 15 -> new GreaterThanOrEqualEvaluator(this.buildReferenceEvaluator(tree.getChild(0)), this.buildReferenceEvaluator(tree.getChild(1)));
            case 20 -> new LessThanOrEqualEvaluator(this.buildReferenceEvaluator(tree.getChild(0)), this.buildReferenceEvaluator(tree.getChild(1)));
            case 26 -> new NotEvaluator(this.buildBooleanEvaluator(tree.getChild(0)));
            case 5 -> new AndEvaluator(this.buildBooleanEvaluator(tree.getChild(0)), this.buildBooleanEvaluator(tree.getChild(1)));
            case 31 -> new OrEvaluator(this.buildBooleanEvaluator(tree.getChild(0)), this.buildBooleanEvaluator(tree.getChild(1)));
            case 18 -> new IsNullEvaluator(this.buildReferenceEvaluator(tree.getChild(0)));
            case 28 -> new NotNullEvaluator(this.buildReferenceEvaluator(tree.getChild(0)));
            default -> throw new HL7QueryParsingException("Cannot build boolean evaluator for '" + tree.getText() + "'");
        };
    }

    Tree getTree() {
        return this.tree;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return "HL7Query[" + this.query + "]";
    }

    public static HL7Query compile(String query) {
        try {
            CommonTokenStream lexerTokenStream = HL7Query.createTokenStream(query);
            HL7QueryParser parser = new HL7QueryParser((TokenStream)lexerTokenStream);
            Tree tree = (Tree)parser.query().getTree();
            return new HL7Query(tree, query);
        }
        catch (HL7QueryParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HL7QueryParsingException(e);
        }
    }

    private static CommonTokenStream createTokenStream(String expression) throws HL7QueryParsingException {
        ANTLRStringStream input = new ANTLRStringStream(expression);
        HL7QueryLexer lexer = new HL7QueryLexer((CharStream)input);
        return new CommonTokenStream((TokenSource)lexer);
    }

    public List<Class<?>> getReturnTypes() {
        ArrayList returnTypes = new ArrayList();
        for (Selection selection : this.selections) {
            returnTypes.add(selection.getEvaluator().getType());
        }
        return returnTypes;
    }

    public QueryResult evaluate(HL7Message message) {
        int totalIterations = 1;
        LinkedHashMap<String, List<Object>> possibleValueMap = new LinkedHashMap<String, List<Object>>();
        for (Declaration declaration : this.declarations) {
            ArrayList<Object> possibleValues;
            Object value = declaration.getDeclaredValue(message);
            if (value == null && declaration.isRequired()) {
                return new MissedResult(this.selections);
            }
            if (value instanceof List) {
                possibleValues = (ArrayList<Object>)value;
            } else if (value instanceof Collection) {
                possibleValues = new ArrayList((Collection)value);
            } else {
                possibleValues = new ArrayList<Object>(1);
                possibleValues.add(value);
            }
            if (possibleValues.isEmpty()) {
                return new MissedResult(this.selections);
            }
            possibleValueMap.put(declaration.getAlias(), possibleValues);
            totalIterations *= possibleValues.size();
        }
        HashSet<Map<String, Object>> resultSet = new HashSet<Map<String, Object>>();
        for (int i = 0; i < totalIterations; ++i) {
            Map<String, Object> aliasValues = HL7Query.assignAliases(possibleValueMap, i);
            aliasValues.put("message", message);
            if (this.whereEvaluator != null && !Boolean.TRUE.equals(this.whereEvaluator.evaluate(aliasValues))) continue;
            HashMap resultMap = new HashMap();
            for (Selection selection : this.selections) {
                Object value = selection.getEvaluator().evaluate(aliasValues);
                resultMap.put(selection.getName(), value);
            }
            resultSet.add(resultMap);
        }
        return new StandardQueryResult(this.selections, resultSet);
    }

    static Map<String, Object> assignAliases(Map<String, List<Object>> possibleValues, int iteration) {
        HashMap<String, Object> aliasMap = new HashMap<String, Object>();
        int divisor = 1;
        for (Map.Entry<String, List<Object>> entry : possibleValues.entrySet()) {
            String alias = entry.getKey();
            List<Object> validValues = entry.getValue();
            int idx = iteration / divisor % validValues.size();
            Object obj = validValues.get(idx);
            aliasMap.put(alias, obj);
            divisor *= validValues.size();
        }
        return aliasMap;
    }

    public String toTreeString() {
        StringBuilder sb = new StringBuilder();
        this.toTreeString(this.tree, sb, 0);
        return sb.toString();
    }

    private void toTreeString(Tree tree, StringBuilder sb, int indentLevel) {
        int i;
        String nodeName = tree.getText();
        for (i = 0; i < indentLevel; ++i) {
            sb.append(" ");
        }
        sb.append(nodeName);
        sb.append("\n");
        for (i = 0; i < tree.getChildCount(); ++i) {
            Tree child = tree.getChild(i);
            this.toTreeString(child, sb, indentLevel + 2);
        }
    }
}

