/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.hl7.model.HL7Component;
import org.apache.nifi.hl7.model.HL7Message;
import org.apache.nifi.hl7.model.HL7Segment;
import org.apache.nifi.hl7.query.evaluator.Evaluator;
import org.apache.nifi.hl7.query.evaluator.IntegerEvaluator;

public class DotEvaluator
implements Evaluator<Object> {
    private final Evaluator<?> lhs;
    private final IntegerEvaluator rhs;

    public DotEvaluator(Evaluator<?> lhs, IntegerEvaluator rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Object evaluate(Map<String, Object> objectMap) {
        Object lhsValue = this.lhs.evaluate(objectMap);
        Integer rhsValue = (Integer)this.rhs.evaluate(objectMap);
        if (lhsValue == null || rhsValue == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (lhsValue instanceof Collection) {
            Collection lhsCollection = (Collection)lhsValue;
            for (Object obj : lhsCollection) {
                Object val = this.getValue(obj, rhsValue);
                results.add(val);
            }
        } else {
            Object val = this.getValue(lhsValue, rhsValue);
            return val;
        }
        return results;
    }

    private Object getValue(Object lhsValue, int rhsValue) {
        List<Object> list;
        if (lhsValue instanceof HL7Message) {
            list = ((HL7Message)lhsValue).getSegments();
        } else if (lhsValue instanceof HL7Segment) {
            list = ((HL7Segment)lhsValue).getFields();
        } else if (lhsValue instanceof HL7Component) {
            list = ((HL7Component)lhsValue).getComponents();
        } else {
            return null;
        }
        if (rhsValue > list.size()) {
            return null;
        }
        return list.get(rhsValue - 1);
    }

    @Override
    public Class<? extends Object> getType() {
        return Object.class;
    }
}

