/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.comparison;

import java.util.regex.Pattern;
import org.apache.nifi.hl7.query.evaluator.Evaluator;
import org.apache.nifi.hl7.query.evaluator.comparison.AbstractComparisonEvaluator;

public abstract class AbstractNumericComparison
extends AbstractComparisonEvaluator {
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");

    public AbstractNumericComparison(Evaluator<?> lhs, Evaluator<?> rhs) {
        super(lhs, rhs);
    }

    @Override
    protected final boolean compare(Object lhs, Object rhs) {
        Double lhsDouble = this.toDouble(lhs);
        if (lhsDouble == null) {
            return false;
        }
        Double rhsDouble = this.toDouble(rhs);
        if (rhsDouble == null) {
            return false;
        }
        return this.compareNumbers(lhsDouble, rhsDouble);
    }

    private Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String && NUMERIC_PATTERN.matcher((String)value).matches()) {
            return Double.parseDouble((String)value);
        }
        return null;
    }

    protected abstract boolean compareNumbers(Double var1, Double var2);
}

