/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hl7;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Visitable;
import ca.uhn.hl7v2.parser.CanonicalModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultEscaping;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;

@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"HL7", "health level 7", "healthcare", "extract", "attributes"})
@CapabilityDescription(value="Extracts information from an HL7 (Health Level 7) formatted FlowFile and adds the information as FlowFile Attributes. The attributes are named as <Segment Name> <dot> <Field Index>. If the segment is repeating, the naming will be <Segment Name> <underscore> <Segment Index> <dot> <Field Index>. For example, we may have an attribute named \"MHS.12\" with a value of \"2.1\" and an attribute named \"OBX_11.3\" with a value of \"93000^CPT4\".")
public class ExtractHL7Attributes
extends AbstractProcessor {
    private static final EncodingCharacters HL7_ENCODING = EncodingCharacters.defaultInstance();
    private static final Escaping HL7_ESCAPING = new DefaultEscaping();
    public static final org.apache.nifi.components.PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Encoding").description("The Character Encoding that is used to encode the HL7 data").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final org.apache.nifi.components.PropertyDescriptor USE_SEGMENT_NAMES = new PropertyDescriptor.Builder().name("use-segment-names").displayName("Use Segment Names").description("Whether or not to use HL7 segment names in attributes").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final org.apache.nifi.components.PropertyDescriptor PARSE_SEGMENT_FIELDS = new PropertyDescriptor.Builder().name("parse-segment-fields").displayName("Parse Segment Fields").description("Whether or not to parse HL7 segment fields into attributes").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final org.apache.nifi.components.PropertyDescriptor SKIP_VALIDATION = new PropertyDescriptor.Builder().name("skip-validation").displayName("Skip Validation").description("Whether or not to validate HL7 message values").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final org.apache.nifi.components.PropertyDescriptor HL7_INPUT_VERSION = new PropertyDescriptor.Builder().name("hl7-input-version").displayName("HL7 Input Version").description("The HL7 version to use for parsing and validation").required(true).allowableValues(new String[]{"autodetect", "2.2", "2.3", "2.3.1", "2.4", "2.5", "2.5.1", "2.6"}).defaultValue("autodetect").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship if it is properly parsed as HL7 and its attributes extracted").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if it cannot be mapped to FlowFile Attributes. This would happen if the FlowFile does not contain valid HL7 data").build();
    private static final List<org.apache.nifi.components.PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CHARACTER_SET, USE_SEGMENT_NAMES, PARSE_SEGMENT_FIELDS, SKIP_VALIDATION, HL7_INPUT_VERSION);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);

    protected List<org.apache.nifi.components.PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).evaluateAttributeExpressions(flowFile).getValue());
        Boolean useSegmentNames = context.getProperty(USE_SEGMENT_NAMES).asBoolean();
        Boolean parseSegmentFields = context.getProperty(PARSE_SEGMENT_FIELDS).asBoolean();
        Boolean skipValidation = context.getProperty(SKIP_VALIDATION).asBoolean();
        String inputVersion = context.getProperty(HL7_INPUT_VERSION).getValue();
        byte[] buffer = new byte[(int)flowFile.getSize()];
        session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])buffer));
        DefaultHapiContext hapiContext = new DefaultHapiContext();
        if (!inputVersion.equals("autodetect")) {
            hapiContext.setModelClassFactory((ModelClassFactory)new CanonicalModelClassFactory(inputVersion));
        }
        if (skipValidation.booleanValue()) {
            hapiContext.setValidationContext(ValidationContextFactory.noValidation());
        }
        PipeParser parser = hapiContext.getPipeParser();
        String hl7Text = new String(buffer, charset);
        try {
            Message message = parser.parse(hl7Text);
            Map<String, String> attributes = ExtractHL7Attributes.getAttributes((Group)message, useSegmentNames, parseSegmentFields);
            flowFile = session.putAllAttributes(flowFile, attributes);
            this.getLogger().debug("Added the following attributes for {}: {}", new Object[]{flowFile, attributes});
        }
        catch (HL7Exception e) {
            this.getLogger().error("Failed to extract attributes from {}", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
    }

    public static Map<String, String> getAttributes(Group group, boolean useNames, boolean parseFields) throws HL7Exception {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        if (!ExtractHL7Attributes.isEmpty((Visitable)group)) {
            for (Map.Entry<String, Segment> segmentEntry : ExtractHL7Attributes.getAllSegments(group).entrySet()) {
                String segmentKey = segmentEntry.getKey();
                Segment segment = segmentEntry.getValue();
                Map<String, Type> fields = ExtractHL7Attributes.getAllFields(segmentKey, segment, useNames);
                for (Map.Entry<String, Type> fieldEntry : fields.entrySet()) {
                    String fieldKey = fieldEntry.getKey();
                    Type field = fieldEntry.getValue();
                    if (parseFields && field instanceof Composite && !ExtractHL7Attributes.isTimestamp(field)) {
                        for (Map.Entry<String, Type> componentEntry : ExtractHL7Attributes.getAllComponents(fieldKey, field, useNames).entrySet()) {
                            String componentKey = componentEntry.getKey();
                            Type component = componentEntry.getValue();
                            String componentValue = HL7_ESCAPING.unescape(component.encode(), HL7_ENCODING);
                            if (StringUtils.isEmpty((CharSequence)componentValue)) continue;
                            attributes.put(componentKey, componentValue);
                        }
                        continue;
                    }
                    String fieldValue = HL7_ESCAPING.unescape(field.encode(), HL7_ENCODING);
                    if (StringUtils.isEmpty((CharSequence)fieldValue)) continue;
                    attributes.put(fieldKey, fieldValue);
                }
            }
        }
        return attributes;
    }

    private static Map<String, Segment> getAllSegments(Group group) throws HL7Exception {
        TreeMap<String, Segment> segments = new TreeMap<String, Segment>();
        ExtractHL7Attributes.addSegments(group, segments, new HashMap<String, Integer>());
        return Collections.unmodifiableMap(segments);
    }

    private static void addSegments(Group group, Map<String, Segment> segments, Map<String, Integer> segmentIndexes) throws HL7Exception {
        if (!ExtractHL7Attributes.isEmpty((Visitable)group)) {
            for (String name : group.getNames()) {
                for (Structure structure : group.getAll(name)) {
                    if (group.isGroup(name) && structure instanceof Group) {
                        ExtractHL7Attributes.addSegments((Group)structure, segments, segmentIndexes);
                        continue;
                    }
                    if (!(structure instanceof Segment)) continue;
                    ExtractHL7Attributes.addSegments((Segment)structure, segments, segmentIndexes);
                }
                segmentIndexes.put(name, segmentIndexes.getOrDefault(name, 1) + 1);
            }
        }
    }

    private static void addSegments(Segment segment, Map<String, Segment> segments, Map<String, Integer> segmentIndexes) throws HL7Exception {
        if (!ExtractHL7Attributes.isEmpty((Visitable)segment)) {
            String segmentName = segment.getName();
            StringBuilder sb = new StringBuilder().append(segmentName);
            if (ExtractHL7Attributes.isRepeating(segment)) {
                int segmentIndex = segmentIndexes.getOrDefault(segmentName, 1);
                sb.append("_").append(segmentIndex);
            }
            String segmentKey = sb.toString();
            segments.put(segmentKey, segment);
        }
    }

    private static Map<String, Type> getAllFields(String segmentKey, Segment segment, boolean useNames) throws HL7Exception {
        TreeMap<String, Type> fields = new TreeMap<String, Type>();
        String[] segmentNames = segment.getNames();
        for (int i = 1; i <= segment.numFields(); ++i) {
            Type[] fieldValues = segment.getField(i);
            if (fieldValues == null || fieldValues.length == 0) continue;
            String segmentName = segmentNames[i - 1];
            String fieldName = useNames && StringUtils.isNotBlank((CharSequence)segmentName) ? WordUtils.capitalize((String)segmentName).replaceAll("\\W+", "") : String.valueOf(i);
            String fieldKey = "%s.%s".formatted(segmentKey, fieldName);
            if (segment.getMaxCardinality(i) == 1) {
                fields.put(fieldKey, fieldValues[0]);
                continue;
            }
            for (int j = 0; j < fieldValues.length; ++j) {
                String repeatableFieldKey = "%s_%s".formatted(fieldKey, j + 1);
                fields.put(repeatableFieldKey, fieldValues[j]);
            }
        }
        return fields;
    }

    private static Map<String, Type> getAllComponents(String fieldKey, Type field, boolean useNames) throws HL7Exception {
        TreeMap<String, Type> components = new TreeMap<String, Type>();
        if (!ExtractHL7Attributes.isEmpty((Visitable)field) && field instanceof Composite) {
            if (useNames) {
                Pattern p = Pattern.compile("^(cm_msg|[a-z][a-z][a-z]?)([0-9]+)_(\\w+)$");
                try {
                    PropertyDescriptor[] properties;
                    for (PropertyDescriptor property : properties = PropertyUtils.getPropertyDescriptors((Object)field)) {
                        Type type;
                        String propertyName = property.getName();
                        Matcher matcher = p.matcher(propertyName);
                        if (!matcher.find() || ExtractHL7Attributes.isEmpty((Visitable)(type = (Type)PropertyUtils.getProperty((Object)field, (String)propertyName)))) continue;
                        String componentName = matcher.group(3);
                        String typeKey = "%s.%s".formatted(fieldKey, componentName);
                        components.put(typeKey, type);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            } else {
                Type[] types = ((Composite)field).getComponents();
                for (int i = 0; i < types.length; ++i) {
                    Type type = types[i];
                    if (ExtractHL7Attributes.isEmpty((Visitable)type)) continue;
                    String fieldName = field.getName();
                    if (fieldName.equals("CM_MSG")) {
                        fieldName = "CM";
                    }
                    String typeKey = "%s.%s.%s".formatted(fieldKey, fieldName, i + 1);
                    components.put(typeKey, type);
                }
            }
        }
        return components;
    }

    private static boolean isTimestamp(Type field) throws HL7Exception {
        if (ExtractHL7Attributes.isEmpty((Visitable)field)) {
            return false;
        }
        String fieldName = field.getName();
        return fieldName.equals("TS") || fieldName.equals("DT") || fieldName.equals("TM");
    }

    private static boolean isRepeating(Segment segment) throws HL7Exception {
        Group grandparent;
        if (ExtractHL7Attributes.isEmpty((Visitable)segment)) {
            return false;
        }
        Group parent = segment.getParent();
        if (parent == (grandparent = parent.getParent())) {
            return false;
        }
        return grandparent.isRepeating(parent.getName());
    }

    private static boolean isEmpty(Visitable visitable) throws HL7Exception {
        return visitable == null || visitable.isEmpty();
    }
}

