/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.Writable;

public class InputStreamWritable
implements Writable {
    private final InputStream inStream;
    private final int size;

    public InputStreamWritable(InputStream inStream, int size) {
        this.inStream = inStream;
        this.size = size;
    }

    public void write(DataOutput output) throws IOException {
        int numRead;
        int totalRead = 0;
        byte[] buffer = new byte[8192];
        output.writeInt(this.size);
        int tempSize = this.size == -1 ? Integer.MAX_VALUE : this.size;
        int toRead = Math.min(tempSize, 8192);
        while (totalRead < tempSize && (numRead = this.inStream.read(buffer, 0, toRead)) != -1) {
            output.write(buffer, 0, numRead);
            toRead = Math.min(8192, tempSize - (totalRead += numRead));
        }
    }

    public void readFields(DataInput di) throws IOException {
        throw new UnsupportedOperationException("InputStreamWritable does not implement #readFields");
    }
}

