/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.inotify;

import java.util.ArrayList;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

class EventTypeValidator
implements Validator {
    EventTypeValidator() {
    }

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        String explanation = this.isValidEventType(input);
        return new ValidationResult.Builder().subject(subject).input(input).valid(explanation == null).explanation(explanation).build();
    }

    private String isValidEventType(String input) {
        if (input != null && !"".equals(input.trim())) {
            String[] events = input.split(",");
            ArrayList<String> invalid = new ArrayList<String>();
            for (String event : events) {
                try {
                    Event.EventType.valueOf((String)event.trim().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    invalid.add(event.trim());
                }
            }
            return invalid.isEmpty() ? null : "The following are not valid event types: " + String.valueOf(invalid);
        }
        return "Empty event types are not allowed.";
    }
}

