/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.hbase.AbstractHBaseLookupService;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.StringUtils;

@Tags(value={"hbase", "record", "lookup", "service"})
@CapabilityDescription(value="A lookup service that retrieves one or more columns from HBase and returns them as a record. The lookup coordinates must contain 'rowKey' which will be the HBase row id.")
public class HBase_2_RecordLookupService
extends AbstractHBaseLookupService
implements LookupService<Record> {
    public Optional<Record> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        if (coordinates.get("rowKey") == null) {
            return Optional.empty();
        }
        String rowKey = coordinates.get("rowKey").toString();
        if (StringUtils.isBlank((String)rowKey)) {
            return Optional.empty();
        }
        byte[] rowKeyBytes = rowKey.getBytes(StandardCharsets.UTF_8);
        try {
            Map<String, Object> values = this.scan(rowKeyBytes);
            if (values.size() > 0) {
                ArrayList<RecordField> fields = new ArrayList<RecordField>();
                for (String key : values.keySet()) {
                    fields.add(new RecordField(key, RecordFieldType.STRING.getDataType()));
                }
                SimpleRecordSchema schema = new SimpleRecordSchema(fields);
                return Optional.ofNullable(new MapRecord((RecordSchema)schema, values));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            this.getLogger().error("Error occurred loading {}", new Object[]{coordinates.get("rowKey")}, (Throwable)e);
            throw new LookupFailureException((Throwable)e);
        }
    }

    public Class<?> getValueType() {
        return Record.class;
    }

    public Set<String> getRequiredKeys() {
        return REQUIRED_KEYS;
    }
}

