/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.logging.ComponentLog;
import org.slf4j.Logger;

public class ExtendedConfiguration
extends Configuration {
    private final BiConsumer<String, Throwable> loggerMethod;
    private final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();

    public ExtendedConfiguration(Logger logger) {
        this.loggerMethod = (arg_0, arg_1) -> ((Logger)logger).error(arg_0, arg_1);
    }

    public ExtendedConfiguration(ComponentLog logger) {
        this.loggerMethod = (arg_0, arg_1) -> ((ComponentLog)logger).error(arg_0, arg_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByNameOrNull(String name) {
        Map<String, WeakReference<Class<Object>>> map;
        ClassLoader classLoader = this.getClassLoader();
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = this.CACHE_CLASSES;
        synchronized (map2) {
            map = this.CACHE_CLASSES.get(classLoader);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                this.CACHE_CLASSES.put(classLoader, map);
            }
        }
        Class<?> clazz = null;
        WeakReference<Class<Object>> ref = map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                this.loggerMethod.accept(e.getMessage(), e);
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        return clazz;
    }
}

