/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.graph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.graph.GraphClientService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;

abstract class AbstractGraphExecutor
extends AbstractProcessor {
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("Client Service").description("The graph client service for connecting to the graph database.").required(true).identifiesControllerService(GraphClientService.class).build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("Graph Query").description("Specifies the graph query. If it is left blank, the processor will attempt to get the query from body.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successful FlowFiles are routed to this relationship").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Failed FlowFiles are routed to this relationship").build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("If there is an input flowfile, the original input flowfile will be written to this relationship if the operation succeeds.").build();
    public static final String ERROR_MESSAGE = "graph.error.message";
    protected List<PropertyDescriptor> queryParameters;

    AbstractGraphExecutor() {
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String name) {
        return new PropertyDescriptor.Builder().name(name).displayName(name).required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.queryParameters = context.getProperties().keySet().stream().filter(prop -> prop.isDynamic()).collect(Collectors.toList());
    }

    protected Map<String, Object> getParameters(ProcessContext context, FlowFile input) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (PropertyDescriptor descriptor : this.queryParameters) {
            String value = context.getProperty(descriptor).evaluateAttributeExpressions(input).getValue();
            params.put(descriptor.getName(), value);
        }
        return params;
    }
}

