/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class SortedStringSetSerializer
extends StdSerializer<Set<String>> {
    public SortedStringSetSerializer() {
        super(Set.class);
    }

    public void serialize(Set<String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ArrayList<String> sorted = new ArrayList<String>(value);
        Collections.sort(sorted);
        gen.writeStartArray();
        for (String str : sorted) {
            gen.writeString(str);
        }
        gen.writeEndArray();
    }
}

