/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.serialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;
import java.util.Set;
import org.apache.nifi.registry.flow.git.serialize.SortedEnumSetSerializer;
import org.apache.nifi.registry.flow.git.serialize.SortedStringListSerializer;
import org.apache.nifi.registry.flow.git.serialize.SortedStringSetSerializer;

public class SortedStringCollectionsModule
extends SimpleModule {
    final Set<String> fieldsToSkipSorting = Set.of("inheritedParameterContexts");

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addBeanSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifyCollectionSerializer(SerializationConfig config, CollectionType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (List.class.isAssignableFrom(valueType.getRawClass()) && valueType.getContentType().getRawClass() == String.class) {
                    return new SortedStringListSerializer(serializer, SortedStringCollectionsModule.this.fieldsToSkipSorting);
                }
                if (Set.class.isAssignableFrom(valueType.getRawClass()) && valueType.getContentType().getRawClass() == String.class) {
                    return new SortedStringSetSerializer();
                }
                if (Set.class.isAssignableFrom(valueType.getRawClass()) && valueType.getContentType().isEnumType()) {
                    return new SortedEnumSetSerializer();
                }
                return serializer;
            }
        });
    }
}

