/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Util {
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("^(.+);\\s*filename\\s*=\\s*\"([^\"]*)\"");

    Util() {
    }

    public static ParsedContentDisposition parseContentDisposition(String contentDisposition) {
        Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
        if (m.find() && m.groupCount() == 2) {
            return new ParsedContentDisposition(m.group(1), m.group(2));
        }
        return null;
    }

    public static class ParsedContentDisposition {
        private final String contentDispositionType;
        private final String fileName;

        private ParsedContentDisposition(String contentDispositionType, String fileName) {
            this.contentDispositionType = contentDispositionType;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getContentDispositionType() {
            return this.contentDispositionType;
        }
    }
}

