/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.pubsub.consume;

import com.google.pubsub.v1.ReceivedMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class WrapperRecord
extends MapRecord {
    public static final String METADATA = "metadata";
    public static final String ATTRIBUTES = "attributes";
    public static final String VALUE = "value";
    private static final RecordField FIELD_ACK_ID_ATTRIBUTE = new RecordField("gcp.pubsub.ackId", RecordFieldType.STRING.getDataType());
    private static final RecordField FIELD_SERIALIZED_SIZE_ATTRIBUTE = new RecordField("gcp.pubsub.messageSize", RecordFieldType.INT.getDataType());
    private static final RecordField FIELD_MESSAGE_ID_ATTRIBUTE = new RecordField("gcp.pubsub.messageId", RecordFieldType.STRING.getDataType());
    private static final RecordField FIELD_MSG_ATTRIBUTES_COUNT_ATTRIBUTE = new RecordField("gcp.pubsub.attributesCount", RecordFieldType.INT.getDataType());
    private static final RecordField FIELD_MSG_PUBLISH_TIME_ATTRIBUTE = new RecordField("gcp.pubsub.publishTime", RecordFieldType.LONG.getDataType());
    public static final RecordSchema SCHEMA_METADATA = new SimpleRecordSchema(Arrays.asList(FIELD_ACK_ID_ATTRIBUTE, FIELD_SERIALIZED_SIZE_ATTRIBUTE, FIELD_MESSAGE_ID_ATTRIBUTE, FIELD_MSG_ATTRIBUTES_COUNT_ATTRIBUTE, FIELD_MSG_PUBLISH_TIME_ATTRIBUTE));
    public static final RecordField FIELD_METADATA = new RecordField("metadata", RecordFieldType.RECORD.getRecordDataType(SCHEMA_METADATA));
    public static final RecordField FIELD_ATTRIBUTES = new RecordField("attributes", RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));

    private static RecordSchema toRecordSchema(Record record) {
        RecordField fieldValue = new RecordField(VALUE, RecordFieldType.RECORD.getRecordDataType(record.getSchema()));
        return new SimpleRecordSchema(Arrays.asList(FIELD_METADATA, FIELD_ATTRIBUTES, fieldValue));
    }

    private static Map<String, Object> toValues(Record record, ReceivedMessage message) {
        HashMap<String, Object> valuesMetadata = new HashMap<String, Object>();
        valuesMetadata.put("gcp.pubsub.ackId", message.getAckId());
        valuesMetadata.put("gcp.pubsub.messageSize", message.getSerializedSize());
        valuesMetadata.put("gcp.pubsub.messageId", message.getMessage().getMessageId());
        valuesMetadata.put("gcp.pubsub.attributesCount", message.getMessage().getAttributesCount());
        valuesMetadata.put("gcp.pubsub.publishTime", message.getMessage().getPublishTime().getSeconds());
        MapRecord recordMetadata = new MapRecord(SCHEMA_METADATA, valuesMetadata);
        HashMap<String, Object> valuesWrapper = new HashMap<String, Object>();
        valuesWrapper.put(METADATA, recordMetadata);
        valuesWrapper.put(ATTRIBUTES, message.getMessage().getAttributesMap());
        valuesWrapper.put(VALUE, record);
        return valuesWrapper;
    }

    public WrapperRecord(Record record, ReceivedMessage message) {
        super(WrapperRecord.toRecordSchema(record), WrapperRecord.toValues(record, message));
    }

    public static RecordSchema toWrapperSchema(RecordSchema recordSchema) {
        RecordField fieldValue = new RecordField(VALUE, RecordFieldType.RECORD.getRecordDataType(recordSchema));
        return new SimpleRecordSchema(Arrays.asList(FIELD_METADATA, FIELD_ATTRIBUTES, fieldValue));
    }
}

