/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.Service;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public abstract class AbstractGCPProcessor<CloudService extends Service<CloudServiceOptions>, CloudServiceOptions extends ServiceOptions<CloudService, CloudServiceOptions>>
extends AbstractProcessor {
    private static final String OBSOLETE_PROXY_HOST = "gcp-proxy-host";
    private static final String OBSOLETE_PROXY_PORT = "gcp-proxy-port";
    private static final String OBSOLETE_PROXY_USERNAME = "gcp-proxy-user-name";
    private static final String OBSOLETE_PROXY_PASSWORD = "gcp-proxy-user-password";
    public static final PropertyDescriptor PROJECT_ID = new PropertyDescriptor.Builder().name("Project ID").description("Google Cloud Project ID").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RETRY_COUNT = new PropertyDescriptor.Builder().name("Number of Retries").description("How many retry attempts should be made before routing to the failure relationship.").defaultValue("6").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor GCP_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("GCP Credentials Provider Service").description("The Controller Service used to obtain Google Cloud Platform credentials.").required(true).identifiesControllerService(GCPCredentialsService.class).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS);
    protected volatile CloudService cloudService;

    protected CloudService getCloudService() {
        return this.cloudService;
    }

    public void migrateProperties(PropertyConfiguration config) {
        ProxyServiceMigration.migrateProxyProperties((PropertyConfiguration)config, (PropertyDescriptor)PROXY_CONFIGURATION_SERVICE, (String)OBSOLETE_PROXY_HOST, (String)OBSOLETE_PROXY_PORT, (String)OBSOLETE_PROXY_USERNAME, (String)OBSOLETE_PROXY_PASSWORD);
        config.renameProperty("gcp-project-id", PROJECT_ID.getName());
        config.renameProperty("gcp-retry-count", RETRY_COUNT.getName());
    }

    protected List<ConfigVerificationResult> verifyCloudService(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ConfigVerificationResult result = null;
        try {
            CloudService cloudService = this.getCloudService(context);
            if (cloudService != null) {
                result = new ConfigVerificationResult.Builder().verificationStepName("Configure Cloud Service").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Successfully configured Cloud Service [%s]", cloudService.getClass().getSimpleName())).build();
            }
        }
        catch (Exception e) {
            verificationLogger.error("Failed to configure Cloud Service", (Throwable)e);
            result = new ConfigVerificationResult.Builder().verificationStepName("Configure Cloud Service").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Failed to configure Cloud Service [%s]: %s", this.cloudService.getClass().getSimpleName(), e.getMessage())).build();
        }
        return result == null ? Collections.emptyList() : Collections.singletonList(result);
    }

    protected GoogleCredentials getGoogleCredentials(ProcessContext context) {
        GCPCredentialsService gcpCredentialsService = (GCPCredentialsService)context.getProperty(GCP_CREDENTIALS_PROVIDER_SERVICE).asControllerService(GCPCredentialsService.class);
        return gcpCredentialsService.getGoogleCredentials();
    }

    protected CloudService getCloudService(ProcessContext context) {
        CloudServiceOptions options = this.getServiceOptions(context, this.getGoogleCredentials(context));
        return (CloudService)(options != null ? options.getService() : null);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.cloudService = this.getCloudService(context);
    }

    protected abstract CloudServiceOptions getServiceOptions(ProcessContext var1, GoogleCredentials var2);

    protected TransportOptions getTransportOptions(ProcessContext context) {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        ProxyAwareTransportFactory transportFactory = new ProxyAwareTransportFactory(proxyConfiguration);
        return HttpTransportOptions.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
    }
}

