/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.vision;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.util.JsonFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.vision.AbstractGcpVisionProcessor;

public abstract class AbstractStartGcpVisionOperation<B extends GeneratedMessageV3.Builder<B>>
extends AbstractGcpVisionProcessor {
    public static final PropertyDescriptor FEATURE_TYPE = new PropertyDescriptor.Builder().name("Vision Feature Type").description("Type of GCP Vision Feature. The value of this property applies when the JSON Payload property is configured. The JSON Payload property value can use Expression Language to reference the value of ${vision-feature-type}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("TEXT_DETECTION").build();
    public static final PropertyDescriptor OUTPUT_BUCKET = new PropertyDescriptor.Builder().name("Output Bucket").description("Name of the GCS bucket where the output of the Vision job will be persisted. The value of this property applies when the JSON Payload property is configured. The JSON Payload property value can use Expression Language to reference the value of ${output-bucket}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null && !context.getProperty(this.getJsonPayloadPropertyDescriptor()).isSet()) {
            return;
        }
        if (flowFile == null) {
            flowFile = session.create();
        }
        try {
            OperationFuture<?, ?> asyncResponse = this.startOperation(session, context, flowFile);
            String operationName = asyncResponse.getName();
            session.putAttribute(flowFile, "operationKey", operationName);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Fail to start GCP Vision operation", (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    @OnStopped
    public void onStopped() throws IOException {
        this.getVisionClient().close();
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("vision-feature-type", FEATURE_TYPE.getName());
        config.renameProperty("output-bucket", OUTPUT_BUCKET.getName());
    }

    protected OperationFuture<?, ?> startOperation(ProcessSession session, ProcessContext context, FlowFile flowFile) {
        B builder = this.newBuilder();
        InputStream inStream = context.getProperty(this.getJsonPayloadPropertyDescriptor()).isSet() ? this.getInputStreamFromProperty(context, flowFile) : session.read(flowFile);
        try (InputStream inputStream = inStream;){
            JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(inputStream), builder);
        }
        catch (IOException e) {
            throw new ProcessException("Read FlowFile Failed", (Throwable)e);
        }
        return this.startOperation(builder);
    }

    private InputStream getInputStreamFromProperty(ProcessContext context, FlowFile flowFile) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(OUTPUT_BUCKET.getName(), this.getAttributeValue(context, flowFile, OUTPUT_BUCKET.getName()));
        attributes.put(FEATURE_TYPE.getName(), this.getAttributeValue(context, flowFile, FEATURE_TYPE.getName()));
        PropertyValue jsonPropertyValue = context.getProperty(this.getJsonPayloadPropertyDescriptor());
        String jsonPayload = jsonPropertyValue.evaluateAttributeExpressions(flowFile, attributes).getValue();
        return new ByteArrayInputStream(jsonPayload.getBytes(StandardCharsets.UTF_8));
    }

    private String getAttributeValue(ProcessContext context, FlowFile flowFile, String name) {
        String flowFileAttribute = flowFile.getAttribute(name);
        PropertyValue propertyValue = context.getProperty(name);
        return flowFileAttribute == null ? propertyValue.getValue() : flowFileAttribute;
    }

    abstract B newBuilder();

    abstract OperationFuture<?, ?> startOperation(B var1);

    abstract PropertyDescriptor getJsonPayloadPropertyDescriptor();
}

