/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.Drive;
import com.google.api.services.drive.model.File;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.drive.GoogleDriveFileInfo;
import org.apache.nifi.processors.gcp.util.GoogleUtils;

public interface GoogleDriveTrait {
    public static final String DRIVE_FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    public static final String DRIVE_SHORTCUT_MIME_TYPE = "application/vnd.google-apps.shortcut";
    public static final String DRIVE_URL = "https://drive.google.com/open?id=";
    public static final String APPLICATION_NAME = "NiFi";
    public static final String OLD_CONNECT_TIMEOUT_PROPERTY_NAME = "connect-timeout";
    public static final String OLD_READ_TIMEOUT_PROPERTY_NAME = "read-timeout";
    public static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    public static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connect Timeout").description("Maximum wait time for connection to Google Drive service.").required(true).defaultValue("20 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Maximum wait time for response from Google Drive service.").required(true).defaultValue("60 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();

    default public com.google.api.services.drive.Drive createDriveService(ProcessContext context, HttpTransport httpTransport, String ... scopes) {
        com.google.api.services.drive.Drive driveService = new Drive.Builder(httpTransport, JSON_FACTORY, this.createHttpRequestInitializer(context, Arrays.asList(scopes))).setApplicationName(APPLICATION_NAME).build();
        return driveService;
    }

    default public HttpRequestInitializer createHttpRequestInitializer(final ProcessContext context, Collection<String> scopes) {
        GoogleCredentials googleCredentials = this.getGoogleCredentials(context).createScoped(scopes);
        HttpCredentialsAdapter httpCredentialsAdapter = new HttpCredentialsAdapter(this, (Credentials)googleCredentials){

            public void initialize(HttpRequest request) throws IOException {
                super.initialize(request);
                int connectTimeout = context.getProperty(CONNECT_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS).intValue();
                int readTimeout = context.getProperty(READ_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS).intValue();
                request.setConnectTimeout(connectTimeout);
                request.setReadTimeout(readTimeout);
            }
        };
        return httpCredentialsAdapter;
    }

    default public GoogleCredentials getGoogleCredentials(ProcessContext context) {
        GCPCredentialsService gcpCredentialsService = (GCPCredentialsService)context.getProperty(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE).asControllerService(GCPCredentialsService.class);
        return gcpCredentialsService.getGoogleCredentials();
    }

    default public GoogleDriveFileInfo.Builder createGoogleDriveFileInfoBuilder(File file) {
        return new GoogleDriveFileInfo.Builder().id(file.getId()).fileName(file.getName()).size(file.getSize() != null ? file.getSize() : 0L).sizeAvailable(file.getSize() != null).createdTime(Optional.ofNullable(file.getCreatedTime()).map(DateTime::getValue).orElse(0L)).modifiedTime(Optional.ofNullable(file.getModifiedTime()).map(DateTime::getValue).orElse(0L)).mimeType(file.getMimeType());
    }

    default public FolderDetails getFolderDetails(com.google.api.services.drive.Drive driveService, String folderId) {
        try {
            String sharedDriveName;
            String sharedDriveId;
            File folder;
            block5: {
                folder = (File)driveService.files().get(folderId).setSupportsAllDrives(Boolean.valueOf(true)).setFields("name, driveId").execute();
                sharedDriveId = folder.getDriveId();
                sharedDriveName = null;
                if (sharedDriveId != null) {
                    try {
                        sharedDriveName = ((Drive)driveService.drives().get(sharedDriveId).setFields("name").execute()).getName();
                    }
                    catch (HttpResponseException e) {
                        if (e.getStatusCode() == 404) break block5;
                        throw e;
                    }
                }
            }
            String folderName = folderId.equals(sharedDriveId) ? sharedDriveName : folder.getName();
            return new FolderDetails(folderId, folderName, sharedDriveId, sharedDriveName);
        }
        catch (IOException ioe) {
            throw new ProcessException("Error while retrieving folder metadata", (Throwable)ioe);
        }
    }

    public static class FolderDetails {
        private final String folderId;
        private final String folderName;
        private final String sharedDriveId;
        private final String sharedDriveName;

        FolderDetails(String folderId, String folderName, String sharedDriveId, String sharedDriveName) {
            this.folderId = folderId;
            this.folderName = folderName;
            this.sharedDriveId = sharedDriveId;
            this.sharedDriveName = sharedDriveName;
        }

        public String getFolderId() {
            return this.folderId;
        }

        public String getFolderName() {
            return this.folderName;
        }

        public String getSharedDriveId() {
            return this.sharedDriveId;
        }

        public String getSharedDriveName() {
            return this.sharedDriveName;
        }
    }
}

