/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.service;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.credentials.factory.AuthenticationStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialsFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.reporting.InitializationException;

@CapabilityDescription(value="Defines credentials for Google Cloud Platform processors. Uses Application Default credentials without configuration. Application Default credentials support environmental variable (GOOGLE_APPLICATION_CREDENTIALS) pointing to a credential file, the config generated by `gcloud auth application-default login`, AppEngine/Compute Engine service accounts, etc.")
@Tags(value={"gcp", "credentials", "provider"})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.ACCESS_ENVIRONMENT_CREDENTIALS, explanation="The default configuration can read environment variables and system properties for credentials")})
public class GCPCredentialsControllerService
extends AbstractControllerService
implements GCPCredentialsService,
VerifiableControllerService {
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CredentialPropertyDescriptors.AUTHENTICATION_STRATEGY, CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON_FILE, CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON, CredentialPropertyDescriptors.WORKLOAD_IDENTITY_AUDIENCE, CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SCOPE, CredentialPropertyDescriptors.WORKLOAD_IDENTITY_TOKEN_ENDPOINT, CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SUBJECT_TOKEN_PROVIDER, CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SUBJECT_TOKEN_TYPE, ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS), CredentialPropertyDescriptors.DELEGATION_STRATEGY, CredentialPropertyDescriptors.DELEGATION_USER);
    private volatile GoogleCredentials googleCredentials;
    protected final CredentialsFactory credentialsProviderFactory = new CredentialsFactory();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public GoogleCredentials getGoogleCredentials() throws ProcessException {
        return this.googleCredentials;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, results, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS);
        return results;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ConfigVerificationResult result;
        try {
            GoogleCredentials credentials = this.getGoogleCredentials(context);
            result = new ConfigVerificationResult.Builder().verificationStepName("Provide Google Credentials").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Successfully provided [%s] as Google Credentials", credentials.getClass().getSimpleName())).build();
        }
        catch (IOException e) {
            result = new ConfigVerificationResult.Builder().verificationStepName("Provide Google Credentials").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Failed to provide Google Credentials: " + e.getMessage(), new Object[0])).build();
        }
        return Collections.singletonList(result);
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        try {
            this.googleCredentials = this.getGoogleCredentials(context);
        }
        catch (IOException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        AuthenticationStrategy authenticationStrategy;
        config.renameProperty("application-default-credentials", CredentialPropertyDescriptors.LEGACY_USE_APPLICATION_DEFAULT_CREDENTIALS.getName());
        config.renameProperty("compute-engine-credentials", CredentialPropertyDescriptors.LEGACY_USE_COMPUTE_ENGINE_CREDENTIALS.getName());
        config.renameProperty("service-account-json-file", CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON_FILE.getName());
        config.renameProperty("service-account-json", CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON.getName());
        ProxyServiceMigration.renameProxyConfigurationServiceProperty((PropertyConfiguration)config);
        boolean legacyFlagsPresent = config.hasProperty(CredentialPropertyDescriptors.LEGACY_USE_APPLICATION_DEFAULT_CREDENTIALS) || config.hasProperty(CredentialPropertyDescriptors.LEGACY_USE_COMPUTE_ENGINE_CREDENTIALS);
        Optional<String> authenticationStrategyValue = config.getRawPropertyValue(CredentialPropertyDescriptors.AUTHENTICATION_STRATEGY).map(String::trim).filter(value -> !value.isEmpty());
        boolean authenticationStrategyMissing = authenticationStrategyValue.isEmpty();
        if ((authenticationStrategyMissing || legacyFlagsPresent) && (authenticationStrategy = this.determineAuthenticationStrategy(config)) != null) {
            config.setProperty(CredentialPropertyDescriptors.AUTHENTICATION_STRATEGY, authenticationStrategy.getValue());
        }
        config.removeProperty(CredentialPropertyDescriptors.LEGACY_USE_APPLICATION_DEFAULT_CREDENTIALS.getName());
        config.removeProperty(CredentialPropertyDescriptors.LEGACY_USE_COMPUTE_ENGINE_CREDENTIALS.getName());
    }

    private AuthenticationStrategy determineAuthenticationStrategy(PropertyConfiguration config) {
        if (this.isTrue(config, CredentialPropertyDescriptors.LEGACY_USE_APPLICATION_DEFAULT_CREDENTIALS)) {
            return AuthenticationStrategy.APPLICATION_DEFAULT;
        }
        if (config.isPropertySet(CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON_FILE)) {
            return AuthenticationStrategy.SERVICE_ACCOUNT_JSON_FILE;
        }
        if (config.isPropertySet(CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SUBJECT_TOKEN_PROVIDER)) {
            return AuthenticationStrategy.WORKLOAD_IDENTITY_FEDERATION;
        }
        if (config.isPropertySet(CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON)) {
            return AuthenticationStrategy.SERVICE_ACCOUNT_JSON;
        }
        if (this.isTrue(config, CredentialPropertyDescriptors.LEGACY_USE_COMPUTE_ENGINE_CREDENTIALS)) {
            return AuthenticationStrategy.COMPUTE_ENGINE;
        }
        return AuthenticationStrategy.APPLICATION_DEFAULT;
    }

    private boolean isTrue(PropertyConfiguration config, PropertyDescriptor property) {
        return config.getRawPropertyValue(property).map(value -> "true".equalsIgnoreCase(value.trim())).orElse(false);
    }

    private GoogleCredentials getGoogleCredentials(ConfigurationContext context) throws IOException {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        ProxyAwareTransportFactory transportFactory = new ProxyAwareTransportFactory(proxyConfiguration);
        return this.credentialsProviderFactory.getGoogleCredentials(context, (HttpTransportFactory)transportFactory);
    }

    public String toString() {
        return "GCPCredentialsControllerService[id=" + this.getIdentifier() + "]";
    }
}

