/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.factory;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processors.gcp.credentials.factory.AuthenticationStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.ApplicationDefaultCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.ComputeEngineCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.JsonFileServiceAccountCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.JsonStringServiceAccountCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.WorkloadIdentityFederationCredentialsStrategy;

public class CredentialsFactory {
    private final Map<AuthenticationStrategy, CredentialsStrategy> strategiesByAuthentication = new EnumMap<AuthenticationStrategy, CredentialsStrategy>(AuthenticationStrategy.class);

    public CredentialsFactory() {
        this.strategiesByAuthentication.put(AuthenticationStrategy.APPLICATION_DEFAULT, new ApplicationDefaultCredentialsStrategy());
        this.strategiesByAuthentication.put(AuthenticationStrategy.SERVICE_ACCOUNT_JSON_FILE, new JsonFileServiceAccountCredentialsStrategy());
        this.strategiesByAuthentication.put(AuthenticationStrategy.SERVICE_ACCOUNT_JSON, new JsonStringServiceAccountCredentialsStrategy());
        this.strategiesByAuthentication.put(AuthenticationStrategy.WORKLOAD_IDENTITY_FEDERATION, new WorkloadIdentityFederationCredentialsStrategy());
        this.strategiesByAuthentication.put(AuthenticationStrategy.COMPUTE_ENGINE, new ComputeEngineCredentialsStrategy());
    }

    public CredentialsStrategy selectPrimaryStrategy(Map<PropertyDescriptor, String> properties) {
        String authenticationStrategyValue = properties.get(CredentialPropertyDescriptors.AUTHENTICATION_STRATEGY);
        Optional<AuthenticationStrategy> authenticationStrategy = AuthenticationStrategy.fromValue(authenticationStrategyValue);
        return authenticationStrategy.map(this.strategiesByAuthentication::get).orElse(this.strategiesByAuthentication.get((Object)AuthenticationStrategy.APPLICATION_DEFAULT));
    }

    public GoogleCredentials getGoogleCredentials(Map<PropertyDescriptor, String> properties, HttpTransportFactory transportFactory) throws IOException {
        CredentialsStrategy primaryStrategy = this.selectPrimaryStrategy(properties);
        if (primaryStrategy == null) {
            throw new IllegalStateException("No matching authentication strategy is configured");
        }
        return primaryStrategy.getGoogleCredentials(properties, transportFactory);
    }

    public GoogleCredentials getGoogleCredentials(ConfigurationContext context, HttpTransportFactory transportFactory) throws IOException {
        CredentialsStrategy primaryStrategy = this.selectPrimaryStrategy(context.getProperties());
        if (primaryStrategy == null) {
            throw new IllegalStateException("No matching authentication strategy is configured");
        }
        return primaryStrategy.getGoogleCredentials(context, transportFactory);
    }
}

