/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.User;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.MultiProcessorUseCase;
import org.apache.nifi.annotation.documentation.ProcessorConfiguration;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.drive.GoogleDriveFileInfo;
import org.apache.nifi.processors.gcp.drive.GoogleDriveTrait;
import org.apache.nifi.processors.gcp.drive.ListGoogleDrive;
import org.apache.nifi.processors.gcp.drive.PutGoogleDrive;
import org.apache.nifi.processors.gcp.util.GoogleUtils;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"google", "drive", "storage", "fetch"})
@CapabilityDescription(value="Fetches files from a Google Drive Folder. Designed to be used in tandem with ListGoogleDrive. Please see Additional Details to set up access to Google Drive.")
@SeeAlso(value={ListGoogleDrive.class, PutGoogleDrive.class})
@ReadsAttribute(attribute="drive.id", description="The id of the file")
@WritesAttributes(value={@WritesAttribute(attribute="drive.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="mime.type", description="The MIME type of the file"), @WritesAttribute(attribute="drive.size", description="The size of the file. Set to 0 when the file size is not available (e.g. externally stored files)."), @WritesAttribute(attribute="drive.size.available", description="Indicates if the file size is known / available"), @WritesAttribute(attribute="drive.timestamp", description="The last modified time or created time (whichever is greater) of the file. The reason for this is that the original modified date of a file is preserved when uploaded to Google Drive. 'Created time' takes the time when the upload occurs. However uploaded files can still be modified later."), @WritesAttribute(attribute="drive.created.time", description="The file's creation time"), @WritesAttribute(attribute="drive.modified.time", description="The file's last modification time"), @WritesAttribute(attribute="drive.owner", description="The owner of the file"), @WritesAttribute(attribute="drive.last.modifying.user", description="The last modifying user of the file"), @WritesAttribute(attribute="drive.web.view.link", description="Web view link to the file"), @WritesAttribute(attribute="drive.web.content.link", description="Web content link to the file"), @WritesAttribute(attribute="drive.parent.folder.id", description="The id of the file's parent folder"), @WritesAttribute(attribute="drive.parent.folder.name", description="The name of the file's parent folder"), @WritesAttribute(attribute="drive.shared.drive.id", description="The id of the shared drive (if the file is located on a shared drive)"), @WritesAttribute(attribute="drive.shared.drive.name", description="The name of the shared drive (if the file is located on a shared drive)"), @WritesAttribute(attribute="error.code", description="The error code returned by Google Drive"), @WritesAttribute(attribute="error.message", description="The error message returned by Google Drive")})
@MultiProcessorUseCase(description="Retrieve all files in a Google Drive folder", keywords={"google", "drive", "google cloud", "state", "retrieve", "fetch", "all", "stream"}, configurations={@ProcessorConfiguration(processorClass=ListGoogleDrive.class, configuration="The \"Folder ID\" property should be set to the ID of the Google Drive folder that files reside in.     See processor documentation / additional details for more information on how to determine a Google Drive folder's ID.\n    If the flow being built is to be reused elsewhere, it's a good idea to parameterize     this property by setting it to something like `#{GOOGLE_DRIVE_FOLDER_ID}`.\n\nThe \"GCP Credentials Provider Service\" property should specify an instance of the GCPCredentialsService in order to provide credentials for accessing the folder.\n\nThe 'success' Relationship of this Processor is then connected to FetchGoogleDrive.\n"), @ProcessorConfiguration(processorClass=FetchGoogleDrive.class, configuration="\"File ID\" = \"${drive.id}\"\n\nThe \"GCP Credentials Provider Service\" property should specify an instance of the GCPCredentialsService in order to provide credentials for accessing the bucket.\n")})
public class FetchGoogleDrive
extends AbstractProcessor
implements GoogleDriveTrait {
    static final String FILE_METADATA_FIELDS_BASIC = "id, name, createdTime, modifiedTime, mimeType, size, exportLinks";
    static final String FILE_METADATA_FIELDS_EXTENDED = "id, name, createdTime, modifiedTime, mimeType, size, exportLinks, owners, lastModifyingUser, webViewLink, webContentLink, parents";
    private static final long EXPORT_SIZE_LIMIT = 10000000L;
    private static final String EXPORT_SIZE_ERROR = "exportSizeLimitExceeded";
    private static final AllowableValue EXPORT_MS_WORD = new AllowableValue("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Microsoft Word");
    private static final AllowableValue EXPORT_OPEN_DOCUMENT = new AllowableValue("application/vnd.oasis.opendocument.text", "OpenDocument Text");
    private static final AllowableValue EXPORT_RICH_TEXT = new AllowableValue("application/rtf", "Rich Text");
    private static final AllowableValue EXPORT_EPUB = new AllowableValue("application/epub+zip", "EPUB");
    private static final AllowableValue EXPORT_PDF = new AllowableValue("application/pdf", "PDF");
    private static final AllowableValue EXPORT_HTML = new AllowableValue("application/zip", "Web Page (HTML)");
    private static final AllowableValue EXPORT_PLAIN_TEXT = new AllowableValue("text/plain", "Plain Text");
    private static final AllowableValue EXPORT_MS_EXCEL = new AllowableValue("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Microsoft Excel");
    private static final AllowableValue EXPORT_OPEN_SPREADSHEET = new AllowableValue("application/x-vnd.oasis.opendocument.spreadsheet", "OpenDocument Spreadsheet");
    private static final AllowableValue EXPORT_CSV = new AllowableValue("text/csv", "CSV (first sheet only)", "Comma-separated values. Only the first sheet will be exported.");
    private static final AllowableValue EXPORT_TSV = new AllowableValue("text/tab-separated-values", "TSV (first sheet only)", "Tab-separate values. Only the first sheet will be exported.");
    private static final AllowableValue EXPORT_MS_POWERPOINT = new AllowableValue("application/vnd.openxmlformats-officedocument.presentationml.presentation", "Microsoft PowerPoint");
    private static final AllowableValue EXPORT_OPEN_PRESENTATION = new AllowableValue("application/vnd.oasis.opendocument.presentation", "OpenDocument Presentation");
    private static final AllowableValue EXPORT_PNG = new AllowableValue("image/png", "PNG");
    private static final AllowableValue EXPORT_JPEG = new AllowableValue("image/jpeg", "JPEG");
    private static final AllowableValue EXPORT_SVG = new AllowableValue("image/svg+xml", "SVG");
    private static final Map<String, String> fileExtensions = new HashMap<String, String>();
    public static final PropertyDescriptor FILE_ID;
    public static final PropertyDescriptor GOOGLE_DOC_EXPORT_TYPE;
    public static final PropertyDescriptor GOOGLE_SPREADSHEET_EXPORT_TYPE;
    public static final PropertyDescriptor GOOGLE_PRESENTATION_EXPORT_TYPE;
    public static final PropertyDescriptor GOOGLE_DRAWING_EXPORT_TYPE;
    public static final Relationship REL_SUCCESS;
    public static final Relationship REL_FAILURE;
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS;
    private static final Set<Relationship> RELATIONSHIPS;
    private volatile Drive driveService;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        this.driveService = this.createDriveService(context, new ProxyAwareTransportFactory(proxyConfiguration).create(), new String[]{"https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/drive.file"});
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        long startNanos = System.nanoTime();
        try {
            boolean listedFile = flowFile.getAttributes().containsKey("drive.listed.folder.id");
            File fileMetadata = this.fetchFileMetadata(fileId, listedFile ? FILE_METADATA_FIELDS_BASIC : FILE_METADATA_FIELDS_EXTENDED);
            GoogleDriveFileInfo.Builder fileInfoBuilder = this.createGoogleDriveFileInfoBuilder(fileMetadata);
            if (!listedFile) {
                fileInfoBuilder.owner(Optional.ofNullable(fileMetadata.getOwners()).filter(owners -> !owners.isEmpty()).map(List::getFirst).map(User::getDisplayName).orElse(null)).lastModifyingUser(Optional.ofNullable(fileMetadata.getLastModifyingUser()).map(User::getDisplayName).orElse(null)).webViewLink(fileMetadata.getWebViewLink()).webContentLink(fileMetadata.getWebContentLink());
                Optional.ofNullable(fileMetadata.getParents()).filter(parents -> !parents.isEmpty()).map(List::getFirst).map(folderId -> this.getFolderDetails(this.driveService, (String)folderId)).ifPresent(folderDetails -> fileInfoBuilder.parentFolderId(folderDetails.getFolderId()).parentFolderName(folderDetails.getFolderName()).sharedDriveId(folderDetails.getSharedDriveId()).sharedDriveName(folderDetails.getSharedDriveName()));
            }
            Map<String, String> attributeMap = fileInfoBuilder.build().toAttributeMap();
            flowFile = this.fetchFile(fileMetadata, session, context, flowFile, attributeMap);
            flowFile = session.putAllAttributes(flowFile, attributeMap);
            String url = "https://drive.google.com/open?id=" + fileMetadata.getId();
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().fetch(flowFile, url, transferMillis);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (GoogleJsonResponseException e) {
            this.handleErrorResponse(session, fileId, flowFile, e);
        }
        catch (Exception e) {
            this.handleUnexpectedError(session, flowFile, fileId, e);
        }
    }

    private String getExportType(String mimeType, ProcessContext context) {
        if (mimeType == null) {
            return null;
        }
        return switch (mimeType) {
            case "application/vnd.google-apps.document" -> context.getProperty(GOOGLE_DOC_EXPORT_TYPE).getValue();
            case "application/vnd.google-apps.spreadsheet" -> context.getProperty(GOOGLE_SPREADSHEET_EXPORT_TYPE).getValue();
            case "application/vnd.google-apps.presentation" -> context.getProperty(GOOGLE_PRESENTATION_EXPORT_TYPE).getValue();
            case "application/vnd.google-apps.drawing" -> context.getProperty(GOOGLE_DRAWING_EXPORT_TYPE).getValue();
            case "application/vnd.google-apps.form" -> "application/zip";
            case "application/vnd.google-apps.script" -> "application/vnd.google-apps.script+json";
            default -> null;
        };
    }

    private FlowFile fetchFile(File fileMetadata, ProcessSession session, ProcessContext context, FlowFile flowFile, Map<String, String> attributeMap) throws IOException {
        String mimeType = fileMetadata.getMimeType();
        String exportType = this.getExportType(mimeType, context);
        if (exportType == null) {
            return this.downloadFile(fileMetadata.getId(), session, flowFile);
        }
        return this.exportFile(fileMetadata, exportType, session, flowFile, attributeMap);
    }

    private FlowFile downloadFile(String fileId, ProcessSession session, FlowFile flowFile) throws IOException {
        try (InputStream driveFileInputStream = this.driveService.files().get(fileId).setSupportsAllDrives(Boolean.valueOf(true)).executeMediaAsInputStream();){
            FlowFile flowFile2 = session.importFrom(driveFileInputStream, flowFile);
            return flowFile2;
        }
    }

    private FlowFile exportFile(File fileMetadata, String exportMimeType, ProcessSession session, FlowFile flowFile, Map<String, String> attributeMap) throws IOException {
        block17: {
            attributeMap.put(CoreAttributes.MIME_TYPE.key(), exportMimeType);
            String fileExtension = fileExtensions.get(exportMimeType);
            if (fileExtension != null) {
                attributeMap.put(CoreAttributes.FILENAME.key(), attributeMap.get(CoreAttributes.FILENAME.key()) + fileExtension);
            }
            if (fileMetadata.getSize() == null || fileMetadata.getSize() < 10000000L) {
                FlowFile flowFile2;
                block16: {
                    InputStream driveFileInputStream = this.driveService.files().export(fileMetadata.getId(), exportMimeType).executeMediaAsInputStream();
                    try {
                        flowFile2 = session.importFrom(driveFileInputStream, flowFile);
                        if (driveFileInputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (driveFileInputStream != null) {
                                try {
                                    driveFileInputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (GoogleJsonResponseException e) {
                            if (e.getContent().contains(EXPORT_SIZE_ERROR)) break block17;
                            throw e;
                        }
                    }
                    driveFileInputStream.close();
                }
                return flowFile2;
            }
        }
        String exportLink = this.getExportLink(fileMetadata, exportMimeType);
        HttpRequestFactory requestFactory = this.driveService.getRequestFactory();
        HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(exportLink));
        HttpResponse response = request.execute();
        try (InputStream driveFileInputStream = response.getContent();){
            FlowFile flowFile3 = session.importFrom(driveFileInputStream, flowFile);
            return flowFile3;
        }
    }

    private String getExportLink(File fileMetadata, String exportType) {
        if (exportType == null) {
            return null;
        }
        Map exportLinks = fileMetadata.getExportLinks();
        if (exportLinks == null) {
            throw new ProcessException(String.format("Export links cannot be found for file [id=%s, mimeType=%s]", fileMetadata.getId(), fileMetadata.getMimeType()));
        }
        String exportLink = (String)fileMetadata.getExportLinks().get(exportType);
        if (exportLink == null) {
            throw new ProcessException(String.format("Export link cannot be found for file [id=%s, mimeType=%s, exportType=%s, exportLinks=%s]", fileMetadata.getId(), fileMetadata.getMimeType(), exportType, exportLinks));
        }
        return exportLink;
    }

    private File fetchFileMetadata(String fileId, String fields) throws IOException {
        return (File)this.driveService.files().get(fileId).setSupportsAllDrives(Boolean.valueOf(true)).setFields(fields).execute();
    }

    private void handleErrorResponse(ProcessSession session, String fileId, FlowFile flowFile, GoogleJsonResponseException e) {
        this.getLogger().error("Fetching File [{}] failed", new Object[]{fileId, e});
        flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getStatusCode()));
        flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    private void handleUnexpectedError(ProcessSession session, FlowFile flowFile, String fileId, Exception e) {
        this.getLogger().error("Fetching File [{}] failed", new Object[]{fileId, e});
        flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    static {
        fileExtensions.put(EXPORT_MS_WORD.getValue(), ".docx");
        fileExtensions.put(EXPORT_OPEN_DOCUMENT.getValue(), ".odt");
        fileExtensions.put(EXPORT_PDF.getValue(), ".pdf");
        fileExtensions.put(EXPORT_RICH_TEXT.getValue(), ".rtf");
        fileExtensions.put(EXPORT_EPUB.getValue(), ".epub");
        fileExtensions.put(EXPORT_HTML.getValue(), ".zip");
        fileExtensions.put(EXPORT_PLAIN_TEXT.getValue(), ".txt");
        fileExtensions.put(EXPORT_MS_EXCEL.getValue(), ".xlsx");
        fileExtensions.put(EXPORT_OPEN_SPREADSHEET.getValue(), ".ods");
        fileExtensions.put(EXPORT_CSV.getValue(), ".csv");
        fileExtensions.put(EXPORT_TSV.getValue(), ".tsv");
        fileExtensions.put(EXPORT_MS_POWERPOINT.getValue(), ".pptx");
        fileExtensions.put(EXPORT_OPEN_PRESENTATION.getValue(), ".odp");
        fileExtensions.put(EXPORT_PNG.getValue(), ".png");
        fileExtensions.put(EXPORT_JPEG.getValue(), ".jpg");
        fileExtensions.put(EXPORT_SVG.getValue(), ".svg");
        fileExtensions.put("application/vnd.google-apps.script+json", ".json");
        FILE_ID = new PropertyDescriptor.Builder().name("drive-file-id").displayName("File ID").description("The Drive ID of the File to fetch. Please see Additional Details for information on how to obtain the Drive ID.").required(true).defaultValue("${drive.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        GOOGLE_DOC_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Doc Export Type").description("Google Documents cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Document, this property specifies the MIME Type to export the document to.").required(true).allowableValues(new DescribedValue[]{EXPORT_PDF, EXPORT_MS_WORD, EXPORT_OPEN_DOCUMENT, EXPORT_PLAIN_TEXT, EXPORT_RICH_TEXT, EXPORT_HTML, EXPORT_EPUB}).defaultValue(EXPORT_PDF.getValue()).build();
        GOOGLE_SPREADSHEET_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Spreadsheet Export Type").description("Google Spreadsheets cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Spreadsheet, this property specifies the MIME Type to export the spreadsheet to.").required(true).allowableValues(new DescribedValue[]{EXPORT_PDF, EXPORT_MS_EXCEL, EXPORT_OPEN_SPREADSHEET, EXPORT_CSV, EXPORT_TSV, EXPORT_HTML}).defaultValue(EXPORT_PDF.getValue()).build();
        GOOGLE_PRESENTATION_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Presentation Export Type").description("Google Presentations cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Presentation, this property specifies the MIME Type to export the presentation to.").required(true).allowableValues(new DescribedValue[]{EXPORT_PDF, EXPORT_MS_POWERPOINT, EXPORT_OPEN_PRESENTATION, EXPORT_PLAIN_TEXT}).defaultValue(EXPORT_PDF.getValue()).build();
        GOOGLE_DRAWING_EXPORT_TYPE = new PropertyDescriptor.Builder().name("Google Drawing Export Type").description("Google Drawings cannot be downloaded directly from Google Drive but instead must be exported to a specified MIME Type. In the event that the incoming FlowFile's MIME Type indicates that the file is a Google Drawing, this property specifies the MIME Type to export the drawing to.").required(true).allowableValues(new DescribedValue[]{EXPORT_PDF, EXPORT_PNG, EXPORT_JPEG, EXPORT_SVG}).defaultValue(EXPORT_PDF.getValue()).build();
        REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile will be routed here for each successfully fetched File.").build();
        REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here for each File for which fetch was attempted but failed.").build();
        PROPERTY_DESCRIPTORS = List.of(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE, FILE_ID, GOOGLE_DOC_EXPORT_TYPE, GOOGLE_SPREADSHEET_EXPORT_TYPE, GOOGLE_PRESENTATION_EXPORT_TYPE, GOOGLE_DRAWING_EXPORT_TYPE, ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS), CONNECT_TIMEOUT, READ_TIMEOUT);
        RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    }
}

