/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.factory.strategies;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.AbstractServiceAccountCredentialsStrategy;

public class JsonFileServiceAccountCredentialsStrategy
extends AbstractServiceAccountCredentialsStrategy {
    public JsonFileServiceAccountCredentialsStrategy() {
        super("Service Account Credentials (Json File)", new PropertyDescriptor[]{CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON_FILE});
    }

    @Override
    protected InputStream getServiceAccountJson(Map<PropertyDescriptor, String> properties) throws IOException {
        String serviceAccountFile = properties.get(CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON_FILE);
        return new BufferedInputStream(Files.newInputStream(Paths.get(serviceAccountFile, new String[0]), new OpenOption[0]));
    }
}

