/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import com.google.api.client.http.HttpTransport;
import com.google.api.services.drive.model.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.User;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.PrimaryNodeOnly;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processor.util.list.AbstractListProcessor;
import org.apache.nifi.processor.util.list.ListedEntityTracker;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.drive.FetchGoogleDrive;
import org.apache.nifi.processors.gcp.drive.GoogleDriveFileInfo;
import org.apache.nifi.processors.gcp.drive.GoogleDriveTrait;
import org.apache.nifi.processors.gcp.drive.PutGoogleDrive;
import org.apache.nifi.processors.gcp.util.GoogleUtils;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.serialization.record.RecordSchema;

@PrimaryNodeOnly
@TriggerSerially
@Tags(value={"google", "drive", "storage"})
@CapabilityDescription(value="Performs a listing of concrete files (shortcuts are ignored) in a Google Drive folder. If the 'Record Writer' property is set, a single Output FlowFile is created, and each file in the listing is written as a single record to the output file. Otherwise, for each file in the listing, an individual FlowFile is created, the metadata being written as FlowFile attributes. This Processor is designed to run on Primary Node only in a cluster. If the primary node changes, the new Primary Node will pick up where the previous node left off without duplicating all of the data. Please see Additional Details to set up access to Google Drive.")
@SeeAlso(value={FetchGoogleDrive.class, PutGoogleDrive.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@WritesAttributes(value={@WritesAttribute(attribute="drive.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="mime.type", description="The MIME type of the file"), @WritesAttribute(attribute="drive.size", description="The size of the file. Set to 0 when the file size is not available (e.g. externally stored files)."), @WritesAttribute(attribute="drive.size.available", description="Indicates if the file size is known / available"), @WritesAttribute(attribute="drive.timestamp", description="The last modified time or created time (whichever is greater) of the file. The reason for this is that the original modified date of a file is preserved when uploaded to Google Drive. 'Created time' takes the time when the upload occurs. However uploaded files can still be modified later."), @WritesAttribute(attribute="drive.created.time", description="The file's creation time"), @WritesAttribute(attribute="drive.modified.time", description="The file's last modification time"), @WritesAttribute(attribute="drive.path", description="The path of the file's directory from the base directory. The path contains the folder names in URL encoded form because Google Drive allows special characters in file names, including '/' (slash) and '\\' (backslash). The URL encoded folder names are separated by '/' in the path."), @WritesAttribute(attribute="drive.owner", description="The owner of the file"), @WritesAttribute(attribute="drive.last.modifying.user", description="The last modifying user of the file"), @WritesAttribute(attribute="drive.web.view.link", description="Web view link to the file"), @WritesAttribute(attribute="drive.web.content.link", description="Web content link to the file"), @WritesAttribute(attribute="drive.parent.folder.id", description="The id of the file's parent folder"), @WritesAttribute(attribute="drive.parent.folder.name", description="The name of the file's parent folder"), @WritesAttribute(attribute="drive.listed.folder.id", description="Web content link to the file"), @WritesAttribute(attribute="drive.listed.folder.name", description="Web content link to the file")})
@Stateful(scopes={Scope.CLUSTER}, description="The processor stores necessary data to be able to keep track what files have been listed already. What exactly needs to be stored depends on the 'Listing Strategy'. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node can pick up where the previous node left off, without duplicating the data.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class ListGoogleDrive
extends AbstractListProcessor<GoogleDriveFileInfo>
implements GoogleDriveTrait {
    public static final PropertyDescriptor FOLDER_ID = new PropertyDescriptor.Builder().name("folder-id").displayName("Folder ID").description("The ID of the folder from which to pull list of files. Please see Additional Details to set up access to Google Drive and obtain Folder ID. WARNING: Unauthorized access to the folder is treated as if the folder was empty. This results in the processor not creating outgoing FlowFiles. No additional error message is provided.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    public static final PropertyDescriptor RECURSIVE_SEARCH = new PropertyDescriptor.Builder().name("recursive-search").displayName("Search Recursively").description("When 'true', will include list of files from concrete sub-folders (ignores shortcuts). Otherwise, will return only files that have the defined 'Folder ID' as their parent directly. WARNING: The listing may fail if there are too many sub-folders (500+).").required(true).defaultValue("true").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor MIN_AGE = new PropertyDescriptor.Builder().name("min-age").displayName("Minimum File Age").description("The minimum age a file must be in order to be considered; any files younger than this will be ignored.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("0 sec").build();
    public static final PropertyDescriptor LISTING_STRATEGY = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractListProcessor.LISTING_STRATEGY).allowableValues(new DescribedValue[]{BY_TIMESTAMPS, BY_ENTITIES, BY_TIME_WINDOW, NO_TRACKING}).build();
    public static final PropertyDescriptor TRACKING_STATE_CACHE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_STATE_CACHE).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor TRACKING_TIME_WINDOW = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.TRACKING_TIME_WINDOW).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    public static final PropertyDescriptor INITIAL_LISTING_TARGET = new PropertyDescriptor.Builder().fromPropertyDescriptor(ListedEntityTracker.INITIAL_LISTING_TARGET).dependsOn(LISTING_STRATEGY, new AllowableValue[]{BY_ENTITIES}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE, FOLDER_ID, RECURSIVE_SEARCH, MIN_AGE, LISTING_STRATEGY, TRACKING_STATE_CACHE, TRACKING_TIME_WINDOW, INITIAL_LISTING_TARGET, RECORD_WRITER, ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS), CONNECT_TIMEOUT, READ_TIMEOUT);
    private volatile com.google.api.services.drive.Drive driveService;
    private volatile String listedFolderId;
    private volatile String listedFolderName;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
    }

    protected Map<String, String> createAttributes(GoogleDriveFileInfo entity, ProcessContext context) {
        return entity.toAttributeMap();
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        HttpTransport httpTransport = new ProxyAwareTransportFactory(proxyConfiguration).create();
        this.driveService = this.createDriveService(context, httpTransport, new String[]{"https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/drive.metadata.readonly"});
        this.listedFolderId = context.getProperty(FOLDER_ID).evaluateAttributeExpressions().getValue();
        this.listedFolderName = this.getFolderName(this.listedFolderId);
    }

    protected String getListingContainerName(ProcessContext context) {
        return String.format("Google Drive Folder [%s]", this.getPath(context));
    }

    protected String getPath(ProcessContext context) {
        return context.getProperty(FOLDER_ID).evaluateAttributeExpressions().getValue();
    }

    protected boolean isListingResetNecessary(PropertyDescriptor property) {
        return LISTING_STRATEGY.equals((Object)property) || FOLDER_ID.equals((Object)property) || RECURSIVE_SEARCH.equals((Object)property);
    }

    protected Scope getStateScope(PropertyContext context) {
        return Scope.CLUSTER;
    }

    protected RecordSchema getRecordSchema() {
        return GoogleDriveFileInfo.getRecordSchema();
    }

    protected String getDefaultTimePrecision() {
        return PRECISION_SECONDS.getValue();
    }

    protected List<GoogleDriveFileInfo> performListing(ProcessContext context, Long minTimestamp, AbstractListProcessor.ListingMode listingMode) throws IOException {
        ArrayList<GoogleDriveFileInfo> listing = new ArrayList<GoogleDriveFileInfo>();
        Boolean recursive = context.getProperty(RECURSIVE_SEARCH).asBoolean();
        Long minAge = context.getProperty(MIN_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        StringBuilder queryTemplateBuilder = new StringBuilder();
        queryTemplateBuilder.append("('%s' in parents)");
        queryTemplateBuilder.append(" and (mimeType != '").append("application/vnd.google-apps.shortcut").append("')");
        queryTemplateBuilder.append(" and trashed = false");
        if (minTimestamp != null && minTimestamp > 0L) {
            String formattedMinTimestamp = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(Instant.ofEpochMilli(minTimestamp), ZoneOffset.UTC));
            queryTemplateBuilder.append(" and (mimeType = '").append("application/vnd.google-apps.folder").append("'");
            queryTemplateBuilder.append(" or modifiedTime >= '").append(formattedMinTimestamp).append("'");
            queryTemplateBuilder.append(" or createdTime >= '").append(formattedMinTimestamp).append("'");
            queryTemplateBuilder.append(")");
        }
        if (minAge != null && minAge > 0L) {
            long maxTimestamp = System.currentTimeMillis() - minAge;
            String formattedMaxTimestamp = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(Instant.ofEpochMilli(maxTimestamp), ZoneOffset.UTC));
            queryTemplateBuilder.append(" and (mimeType = '").append("application/vnd.google-apps.folder").append("'");
            queryTemplateBuilder.append(" or (modifiedTime < '").append(formattedMaxTimestamp).append("'");
            queryTemplateBuilder.append(" and createdTime < '").append(formattedMaxTimestamp).append("')");
            queryTemplateBuilder.append(")");
        }
        String queryTemplate = queryTemplateBuilder.toString();
        String listedFolderPath = this.urlEncode(this.listedFolderName);
        this.queryFolder(this.listedFolderId, this.listedFolderName, listedFolderPath, queryTemplate, recursive, listing);
        return listing;
    }

    protected Integer countUnfilteredListing(ProcessContext context) throws IOException {
        return this.performListing(context, null, AbstractListProcessor.ListingMode.CONFIGURATION_VERIFICATION).size();
    }

    private String getFolderName(String folderId) throws IOException {
        File folder = (File)this.driveService.files().get(folderId).setSupportsAllDrives(Boolean.valueOf(true)).setFields("name, driveId").execute();
        if (folderId.equals(folder.getDriveId())) {
            return ((Drive)this.driveService.drives().get(folderId).setFields("name").execute()).getName();
        }
        return folder.getName();
    }

    private void queryFolder(String folderId, String folderName, String folderPath, String queryTemplate, boolean recursive, List<GoogleDriveFileInfo> listing) throws IOException {
        FileList result;
        ArrayList<File> subfolders = new ArrayList<File>();
        String pageToken = null;
        do {
            result = (FileList)this.driveService.files().list().setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setQ(String.format(queryTemplate, folderId)).setPageToken(pageToken).setFields("nextPageToken, files(id, name, size, createdTime, modifiedTime, mimeType, owners, lastModifyingUser, webViewLink, webContentLink)").execute();
            for (File file : result.getFiles()) {
                if ("application/vnd.google-apps.folder".equals(file.getMimeType())) {
                    if (!recursive) continue;
                    subfolders.add(file);
                    continue;
                }
                GoogleDriveFileInfo.Builder builder = this.createGoogleDriveFileInfoBuilder(file).path(folderPath).owner(Optional.ofNullable(file.getOwners()).filter(owners -> !owners.isEmpty()).map(List::getFirst).map(User::getDisplayName).orElse(null)).lastModifyingUser(Optional.ofNullable(file.getLastModifyingUser()).map(User::getDisplayName).orElse(null)).webViewLink(file.getWebViewLink()).webContentLink(file.getWebContentLink()).parentFolderId(folderId).parentFolderName(folderName).listedFolderId(this.listedFolderId).listedFolderName(this.listedFolderName);
                listing.add(builder.build());
            }
        } while ((pageToken = result.getNextPageToken()) != null);
        for (File subfolder : subfolders) {
            String subfolderPath = folderPath + "/" + this.urlEncode(subfolder.getName());
            this.queryFolder(subfolder.getId(), subfolder.getName(), subfolderPath, queryTemplate, true, listing);
        }
    }

    private String urlEncode(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }
}

