/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.processor.util.list.ListableEntity;
import org.apache.nifi.processors.gcp.drive.GoogleDriveAttributes;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class GoogleDriveFileInfo
implements ListableEntity {
    private static final RecordSchema SCHEMA;
    private final String id;
    private final String fileName;
    private final long size;
    private final boolean sizeAvailable;
    private final long createdTime;
    private final long modifiedTime;
    private final String mimeType;
    private final String path;
    private final String owner;
    private final String lastModifyingUser;
    private final String webViewLink;
    private final String webContentLink;
    private final String parentFolderId;
    private final String parentFolderName;
    private final String listedFolderId;
    private final String listedFolderName;

    public String getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isSizeAvailable() {
        return this.sizeAvailable;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getPath() {
        return this.path;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getLastModifyingUser() {
        return this.lastModifyingUser;
    }

    public String getWebViewLink() {
        return this.webViewLink;
    }

    public String getWebContentLink() {
        return this.webContentLink;
    }

    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public String getParentFolderName() {
        return this.parentFolderName;
    }

    public String getListedFolderId() {
        return this.listedFolderId;
    }

    public String getListedFolderName() {
        return this.listedFolderName;
    }

    public Record toRecord() {
        return new MapRecord(SCHEMA, this.toMap());
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("drive.id", this.getId());
        values.put(GoogleDriveAttributes.FILENAME, this.getName());
        values.put("drive.size", this.getSize());
        values.put("drive.size.available", this.isSizeAvailable());
        values.put("drive.created.time", Instant.ofEpochMilli(this.getCreatedTime()).toString());
        values.put("drive.modified.time", Instant.ofEpochMilli(this.getModifiedTime()).toString());
        values.put("drive.timestamp", this.getTimestamp());
        values.put(GoogleDriveAttributes.MIME_TYPE, this.getMimeType());
        values.put("drive.path", this.getPath());
        values.put("drive.owner", this.getOwner());
        values.put("drive.last.modifying.user", this.getLastModifyingUser());
        values.put("drive.web.view.link", this.getWebViewLink());
        values.put("drive.web.content.link", this.getWebContentLink());
        values.put("drive.parent.folder.id", this.getParentFolderId());
        values.put("drive.parent.folder.name", this.getParentFolderName());
        values.put("drive.listed.folder.id", this.getListedFolderId());
        values.put("drive.listed.folder.name", this.getListedFolderName());
        return values;
    }

    public Map<String, String> toAttributeMap() {
        return this.toMap().entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    public static RecordSchema getRecordSchema() {
        return SCHEMA;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoogleDriveFileInfo other = (GoogleDriveFileInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    private GoogleDriveFileInfo(Builder builder) {
        this.id = builder.id;
        this.fileName = builder.fileName;
        this.size = builder.size;
        this.sizeAvailable = builder.sizeAvailable;
        this.createdTime = builder.createdTime;
        this.modifiedTime = builder.modifiedTime;
        this.mimeType = builder.mimeType;
        this.path = builder.path;
        this.owner = builder.owner;
        this.lastModifyingUser = builder.lastModifyingUser;
        this.webViewLink = builder.webViewLink;
        this.webContentLink = builder.webContentLink;
        this.parentFolderId = builder.parentFolderId;
        this.parentFolderName = builder.parentFolderName;
        this.listedFolderId = builder.listedFolderId;
        this.listedFolderName = builder.listedFolderName;
    }

    public String getName() {
        return this.getFileName();
    }

    public String getIdentifier() {
        return this.getId();
    }

    public long getTimestamp() {
        long timestamp = Math.max(this.getCreatedTime(), this.getModifiedTime());
        return timestamp;
    }

    public long getSize() {
        return this.size;
    }

    static {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.add(new RecordField("drive.id", RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(GoogleDriveAttributes.FILENAME, RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField("drive.size", RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField("drive.size.available", RecordFieldType.BOOLEAN.getDataType(), false));
        recordFields.add(new RecordField("drive.timestamp", RecordFieldType.LONG.getDataType(), false));
        recordFields.add(new RecordField("drive.created.time", RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField("drive.modified.time", RecordFieldType.STRING.getDataType(), false));
        recordFields.add(new RecordField(GoogleDriveAttributes.MIME_TYPE, RecordFieldType.STRING.getDataType()));
        recordFields.add(new RecordField("drive.path", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.owner", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.last.modifying.user", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.web.view.link", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.web.content.link", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.parent.folder.id", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.parent.folder.name", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.listed.folder.id", RecordFieldType.STRING.getDataType(), true));
        recordFields.add(new RecordField("drive.listed.folder.name", RecordFieldType.STRING.getDataType(), true));
        SCHEMA = new SimpleRecordSchema(recordFields);
    }

    public static final class Builder {
        private String id;
        private String fileName;
        private long size;
        private boolean sizeAvailable;
        private long createdTime;
        private long modifiedTime;
        private String mimeType;
        private String path;
        private String owner;
        private String lastModifyingUser;
        private String webViewLink;
        private String webContentLink;
        private String parentFolderId;
        private String parentFolderName;
        private String listedFolderId;
        private String listedFolderName;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder sizeAvailable(boolean sizeAvailable) {
            this.sizeAvailable = sizeAvailable;
            return this;
        }

        public Builder createdTime(long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Builder modifiedTime(long modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder lastModifyingUser(String lastModifyingUser) {
            this.lastModifyingUser = lastModifyingUser;
            return this;
        }

        public Builder webViewLink(String webViewLink) {
            this.webViewLink = webViewLink;
            return this;
        }

        public Builder webContentLink(String webContentLink) {
            this.webContentLink = webContentLink;
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public Builder parentFolderName(String parentFolderName) {
            this.parentFolderName = parentFolderName;
            return this;
        }

        public Builder listedFolderId(String listedFolderId) {
            this.listedFolderId = listedFolderId;
            return this;
        }

        public Builder listedFolderName(String listedFolderName) {
            this.listedFolderName = listedFolderName;
            return this;
        }

        public GoogleDriveFileInfo build() {
            return new GoogleDriveFileInfo(this);
        }
    }
}

