/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.factory.strategies;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.gcp.credentials.factory.DelegationStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.AbstractCredentialsStrategy;

public abstract class AbstractServiceAccountCredentialsStrategy
extends AbstractCredentialsStrategy {
    public AbstractServiceAccountCredentialsStrategy(String name, PropertyDescriptor[] requiredProperties) {
        super(name, requiredProperties);
    }

    protected abstract InputStream getServiceAccountJson(Map<PropertyDescriptor, String> var1) throws IOException;

    @Override
    public GoogleCredentials getGoogleCredentials(Map<PropertyDescriptor, String> properties, HttpTransportFactory transportFactory) throws IOException {
        String delegationStrategy = properties.get(CredentialPropertyDescriptors.DELEGATION_STRATEGY);
        if (delegationStrategy != null && delegationStrategy.equals(DelegationStrategy.DELEGATED_ACCOUNT.getValue())) {
            String delegationUser = properties.get(CredentialPropertyDescriptors.DELEGATION_USER);
            return GoogleCredentials.fromStream((InputStream)this.getServiceAccountJson(properties), (HttpTransportFactory)transportFactory).createDelegated(delegationUser);
        }
        return GoogleCredentials.fromStream((InputStream)this.getServiceAccountJson(properties), (HttpTransportFactory)transportFactory);
    }
}

