/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kubernetes.state.provider;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.kubernetes.client.ServiceAccountNamespaceProvider;
import org.apache.nifi.kubernetes.client.StandardKubernetesClientProvider;
import org.apache.nifi.kubernetes.state.provider.StandardStateMap;
import org.apache.nifi.logging.ComponentLog;

public class KubernetesConfigMapStateProvider
extends AbstractConfigurableComponent
implements StateProvider {
    static final PropertyDescriptor CONFIG_MAP_NAME_PREFIX = new PropertyDescriptor.Builder().name("ConfigMap Name Prefix").description("Optional prefix that the Provider will prepend to Kubernetes ConfigMap names. The resulting ConfigMap name will contain nifi-component and the component identifier.").addValidator(Validator.VALID).required(false).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(CONFIG_MAP_NAME_PREFIX);
    private static final int MAX_UPDATE_ATTEMPTS = 5;
    private static final Scope[] SUPPORTED_SCOPES = new Scope[]{Scope.CLUSTER};
    private static final Charset KEY_CHARACTER_SET = StandardCharsets.UTF_8;
    private static final String CONFIG_MAP_NAME_FORMAT = "%snifi-component-%%s";
    private static final String CONFIG_MAP_NAME_PATTERN_FORMAT = "^%snifi-component-(.+)$";
    private static final String PREFIX_SEPARATOR = "-";
    private static final String EMPTY_PREFIX = "";
    private static final int COMPONENT_ID_GROUP = 1;
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder decoder = Base64.getUrlDecoder();
    private final AtomicBoolean enabled = new AtomicBoolean();
    private String configMapNameFormat;
    private Pattern configMapNamePattern;
    private KubernetesClient kubernetesClient;
    private String namespace;
    private String identifier;
    private ComponentLog logger;

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void initialize(StateProviderInitializationContext context) {
        this.identifier = context.getIdentifier();
        this.logger = context.getLogger();
        this.kubernetesClient = this.getKubernetesClient();
        this.namespace = new ServiceAccountNamespaceProvider().getNamespace();
        PropertyValue configMapNamePrefixProperty = context.getProperty(CONFIG_MAP_NAME_PREFIX);
        String prefixPropertyValue = configMapNamePrefixProperty.getValue();
        String configMapNamePrefix = prefixPropertyValue == null || prefixPropertyValue.isBlank() ? EMPTY_PREFIX : prefixPropertyValue + PREFIX_SEPARATOR;
        this.configMapNameFormat = String.format(CONFIG_MAP_NAME_FORMAT, configMapNamePrefix);
        this.configMapNamePattern = Pattern.compile(String.format(CONFIG_MAP_NAME_PATTERN_FORMAT, configMapNamePrefix));
    }

    public void shutdown() {
        this.kubernetesClient.close();
        this.logger.info("Provider shutdown");
    }

    public void setState(Map<String, String> state, String componentId) throws IOException {
        try {
            ConfigMap configMap = this.createConfigMapBuilder(state, componentId).build();
            Resource configMapResource = (Resource)this.kubernetesClient.configMaps().resource((Object)configMap);
            ConfigMap configMapCreated = null;
            boolean create = false;
            for (int attempt = 0; attempt < 5; ++attempt) {
                try {
                    if (create) {
                        configMapCreated = (ConfigMap)configMapResource.create();
                        break;
                    }
                    configMapCreated = (ConfigMap)configMapResource.update();
                    break;
                }
                catch (KubernetesClientException e) {
                    int returnCode = e.getCode();
                    if (returnCode == 404) {
                        attempt = 0;
                        create = true;
                        continue;
                    }
                    if (returnCode >= 500) {
                        if (attempt != 4) continue;
                        throw e;
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (attempt < 4) {
                        this.logger.warn("Failed to update state for component with ID {}. Will attempt to update the resource again.", new Object[]{componentId, e});
                        continue;
                    }
                    this.logger.error("Failed to update state for component with ID {}", new Object[]{componentId, e});
                    throw e;
                }
            }
            if (configMapCreated == null) {
                throw new IOException("Exhausted maximum number of attempts (%s) to update state for component with ID %s but could not update it".formatted(5, componentId));
            }
            Optional<String> version = this.getVersion(configMapCreated);
            this.logger.debug("Set State Component ID [{}] Version [{}]", new Object[]{componentId, version});
        }
        catch (KubernetesClientException e) {
            if (this.isNotFound(e.getCode())) {
                this.logger.debug("State not found for Component ID [{}]", new Object[]{componentId, e});
            }
            throw new IOException(String.format("Failed to update state for Component with ID [%s]", componentId), e);
        }
        catch (RuntimeException e) {
            throw new IOException(String.format("Failed to update state for Component with ID [%s]", componentId), e);
        }
    }

    public StateMap getState(String componentId) throws IOException {
        try {
            ConfigMap configMap = (ConfigMap)this.configMapResource(componentId).get();
            Map<String, String> data = configMap == null ? Collections.emptyMap() : this.getDecodedMap(configMap.getData());
            Optional<String> version = configMap == null ? Optional.empty() : this.getVersion(configMap);
            return new StandardStateMap(data, version);
        }
        catch (RuntimeException e) {
            throw new IOException(String.format("Get failed for Component ID [%s]", componentId), e);
        }
    }

    public boolean replace(StateMap currentState, Map<String, String> state, String componentId) throws IOException {
        ConfigMapBuilder configMapBuilder = this.createConfigMapBuilder(state, componentId);
        Optional stateVersion = currentState.getStateVersion();
        if (stateVersion.isPresent()) {
            String resourceVersion = (String)stateVersion.get();
            ((ConfigMapFluent.MetadataNested)configMapBuilder.editOrNewMetadata().withResourceVersion(resourceVersion)).endMetadata();
        }
        ConfigMap configMap = configMapBuilder.build();
        try {
            Resource configMapResource = (Resource)this.kubernetesClient.configMaps().resource((Object)configMap);
            ConfigMap newConfigMap = stateVersion.isPresent() ? (ConfigMap)configMapResource.update() : (ConfigMap)configMapResource.create();
            Optional<String> version = this.getVersion(newConfigMap);
            this.logger.debug("Replaced State Component ID [{}] Version [{}]", new Object[]{componentId, version});
            return true;
        }
        catch (KubernetesClientException e) {
            if (this.isNotFoundOrConflict(e.getCode())) {
                this.logger.debug("Replace State Failed Component ID [{}] Version [{}]", new Object[]{componentId, stateVersion, e});
                return false;
            }
            throw new IOException(String.format("Replace failed for Component ID [%s]", componentId), e);
        }
        catch (RuntimeException e) {
            throw new IOException(String.format("Replace failed for Component ID [%s]", componentId), e);
        }
    }

    public void clear(String componentId) throws IOException {
        try {
            this.setState(Collections.emptyMap(), componentId);
        }
        catch (RuntimeException e) {
            throw new IOException(String.format("Clear failed for Component ID [%s]", componentId), e);
        }
    }

    public void onComponentRemoved(String componentId) throws IOException {
        try {
            List deleteStatus = this.configMapResource(componentId).delete();
            this.logger.debug("Config Map [{}] deleted {}", new Object[]{componentId, deleteStatus});
        }
        catch (RuntimeException e) {
            throw new IOException(String.format("Remove failed for Component ID [%s]", componentId), e);
        }
    }

    public void enable() {
        this.enabled.getAndSet(true);
    }

    public void disable() {
        this.enabled.getAndSet(false);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public Scope[] getSupportedScopes() {
        return SUPPORTED_SCOPES;
    }

    public boolean isComponentEnumerationSupported() {
        return true;
    }

    public Collection<String> getStoredComponentIds() {
        ConfigMapList configMapList = (ConfigMapList)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(this.namespace)).list();
        return configMapList.getItems().stream().map(ConfigMap::getMetadata).map(ObjectMeta::getName).map(this.configMapNamePattern::matcher).filter(Matcher::matches).map(matcher -> matcher.group(1)).toList();
    }

    protected KubernetesClient getKubernetesClient() {
        return new StandardKubernetesClientProvider().getKubernetesClient();
    }

    private Resource<ConfigMap> configMapResource(String componentId) {
        String name = this.getConfigMapName(componentId);
        return (Resource)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(this.namespace)).withName(name);
    }

    private ConfigMapBuilder createConfigMapBuilder(Map<String, String> state, String componentId) {
        Map<String, String> encodedData = this.getEncodedMap(state);
        String name = this.getConfigMapName(componentId);
        return (ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withNamespace(this.namespace)).withName(name)).endMetadata()).withData(encodedData);
    }

    private String getConfigMapName(String componentId) {
        return String.format(this.configMapNameFormat, componentId);
    }

    private Optional<String> getVersion(ConfigMap configMap) {
        ObjectMeta metadata = configMap.getMetadata();
        String resourceVersion = metadata.getResourceVersion();
        return Optional.ofNullable(resourceVersion);
    }

    private Map<String, String> getEncodedMap(Map<String, String> stateMap) {
        LinkedHashMap<String, String> encodedMap = new LinkedHashMap<String, String>();
        stateMap.forEach((key, value) -> {
            byte[] keyBytes = key.getBytes(KEY_CHARACTER_SET);
            String encodedKey = encoder.encodeToString(keyBytes);
            encodedMap.put(encodedKey, (String)value);
        });
        return encodedMap;
    }

    private Map<String, String> getDecodedMap(Map<String, String> configMap) {
        LinkedHashMap<String, String> decodedMap = new LinkedHashMap<String, String>();
        configMap.forEach((key, value) -> {
            byte[] keyBytes = decoder.decode((String)key);
            String decodedKey = new String(keyBytes, KEY_CHARACTER_SET);
            decodedMap.put(decodedKey, (String)value);
        });
        return decodedMap;
    }

    private boolean isNotFound(int code) {
        return 404 == code;
    }

    private boolean isNotFoundOrConflict(int code) {
        return this.isNotFound(code) || 409 == code;
    }
}

