/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kubernetes.leader.election.command;

import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.nifi.kubernetes.client.KubernetesClientProvider;
import org.apache.nifi.kubernetes.leader.election.command.LeaderElectionCommand;
import org.apache.nifi.kubernetes.leader.election.command.LeaderElectionCommandProvider;

public class StandardLeaderElectionCommandProvider
implements LeaderElectionCommandProvider {
    private final KubernetesClient kubernetesClient;
    private final String namespace;

    public StandardLeaderElectionCommandProvider(KubernetesClientProvider kubernetesClientProvider, String namespace) {
        this.kubernetesClient = Objects.requireNonNull(kubernetesClientProvider).getKubernetesClient();
        this.namespace = Objects.requireNonNull(namespace);
    }

    @Override
    public Runnable getCommand(String name, String identity, Runnable onStartLeading, Runnable onStopLeading, Consumer<String> onNewLeader) {
        return new LeaderElectionCommand(this.kubernetesClient, this.namespace, name, identity, onStartLeading, onStopLeading, onNewLeader);
    }

    @Override
    public Optional<String> findLeader(String name) {
        try {
            Lease lease = (Lease)((Resource)((NonNamespaceOperation)this.kubernetesClient.leases().inNamespace(this.namespace)).withName(name)).get();
            String currentHolderIdentity = this.getCurrentHolderIdentity(lease);
            return Optional.ofNullable(currentHolderIdentity);
        }
        catch (KubernetesClientException e) {
            if (this.isNotFound(e)) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.kubernetesClient.close();
    }

    private boolean isNotFound(KubernetesClientException e) {
        return 404 == e.getCode();
    }

    private String getCurrentHolderIdentity(Lease lease) {
        String holderIdentity;
        if (lease == null) {
            holderIdentity = null;
        } else {
            LeaseSpec spec = lease.getSpec();
            ZonedDateTime expiration = this.getExpiration(spec);
            ZonedDateTime now = ZonedDateTime.now();
            holderIdentity = now.isAfter(expiration) ? null : spec.getHolderIdentity();
        }
        return holderIdentity;
    }

    private ZonedDateTime getExpiration(LeaseSpec leaseSpec) {
        ZonedDateTime renewTime = leaseSpec.getRenewTime();
        Integer leaseDuration = leaseSpec.getLeaseDurationSeconds();
        return renewTime.plusSeconds(leaseDuration.intValue());
    }
}

