/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kubernetes.leader.election.command;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElector;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LeaderElectionCommand
implements Runnable {
    private static final Duration LEASE_DURATION = Duration.ofSeconds(15L);
    private static final Duration RENEW_DEADLINE = Duration.ofSeconds(10L);
    private static final Duration RETRY_PERIOD = Duration.ofSeconds(2L);
    private static final Logger logger = LoggerFactory.getLogger(LeaderElectionCommand.class);
    private final KubernetesClient kubernetesClient;
    private final LeaderCallbacks leaderCallbacks;
    private final String name;
    private final Lock lock;

    LeaderElectionCommand(KubernetesClient kubernetesClient, String namespace, String name, String identity, Runnable onStartLeading, Runnable onStopLeading, Consumer<String> onNewLeader) {
        this.kubernetesClient = kubernetesClient;
        this.name = Objects.requireNonNull(name, "Name required");
        this.lock = new LeaseLock(namespace, name, identity);
        this.leaderCallbacks = new LeaderCallbacks(onStartLeading, onStopLeading, onNewLeader);
    }

    @Override
    public void run() {
        logger.info("Election Name [{}] ID [{}] Participation STARTED", (Object)this.name, (Object)this.lock.identity());
        while (!Thread.currentThread().isInterrupted()) {
            this.runLeaderElector();
        }
        logger.info("Election Name [{}] ID [{}] Participation STOPPED", (Object)this.name, (Object)this.lock.identity());
    }

    private void runLeaderElector() {
        logger.info("Election Name [{}] ID [{}] Command STARTED", (Object)this.name, (Object)this.lock.identity());
        try {
            LeaderElectionConfig leaderElectionConfig = this.getLeaderElectionConfig();
            LeaderElector leaderElector = this.kubernetesClient.leaderElector().withConfig(leaderElectionConfig).build();
            leaderElector.run();
            logger.info("Election Name [{}] ID [{}] Command STOPPED", (Object)this.name, (Object)this.lock.identity());
        }
        catch (RuntimeException e) {
            logger.error("Election Name [{}] ID [{}] Command FAILED", new Object[]{this.name, this.lock.identity(), e});
        }
    }

    private LeaderElectionConfig getLeaderElectionConfig() {
        return ((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withName(this.name)).withLeaderCallbacks(this.leaderCallbacks)).withLock(this.lock)).withLeaseDuration(LEASE_DURATION)).withRenewDeadline(RENEW_DEADLINE)).withRetryPeriod(RETRY_PERIOD)).build();
    }
}

