/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.StatelessGroupScheduledState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetainExistingStateComponentScheduler
implements ComponentScheduler {
    private static final Logger logger = LoggerFactory.getLogger(RetainExistingStateComponentScheduler.class);
    private final ComponentScheduler delegate;
    private final Map<String, org.apache.nifi.controller.ScheduledState> componentStates;
    private final Map<String, ControllerServiceState> controllerServiceStates;

    public RetainExistingStateComponentScheduler(ProcessGroup processGroup, ComponentScheduler delegate) {
        this.delegate = delegate;
        this.componentStates = this.mapComponentStates(processGroup);
        this.controllerServiceStates = this.mapControllerServiceStates(processGroup);
    }

    public void startComponent(Connectable component) {
        org.apache.nifi.controller.ScheduledState existingState = this.componentStates.get(component.getIdentifier());
        if (existingState == null) {
            logger.debug("Will not start {} because it was not previously known in this Process Group", (Object)component);
            return;
        }
        if (existingState != org.apache.nifi.controller.ScheduledState.RUNNING && existingState != org.apache.nifi.controller.ScheduledState.STARTING) {
            logger.debug("Will not start {} because its previous state was {}", (Object)component, (Object)existingState);
            return;
        }
        logger.debug("Starting {}", (Object)component);
        this.delegate.startComponent(component);
    }

    public void startStatelessGroup(ProcessGroup group) {
        org.apache.nifi.controller.ScheduledState existingState = this.componentStates.get(group.getIdentifier());
        if (existingState == null) {
            logger.debug("Will not start {} because it was not previously known in this Process Group", (Object)group);
            return;
        }
        if (existingState != org.apache.nifi.controller.ScheduledState.RUNNING && existingState != org.apache.nifi.controller.ScheduledState.STARTING) {
            logger.debug("Will not start {} because its previous state was {}", (Object)group, (Object)existingState);
            return;
        }
        logger.debug("Starting {}", (Object)group);
        this.delegate.startStatelessGroup(group);
    }

    public void stopStatelessGroup(ProcessGroup group) {
        this.delegate.stopStatelessGroup(group);
    }

    public void stopComponent(Connectable component) {
        this.delegate.stopComponent(component);
    }

    public void transitionComponentState(Connectable component, ScheduledState desiredState) {
        this.delegate.transitionComponentState(component, desiredState);
    }

    public void enableControllerServicesAsync(Collection<ControllerServiceNode> controllerServices) {
        HashSet<ControllerServiceNode> toEnable = new HashSet<ControllerServiceNode>();
        for (ControllerServiceNode service : controllerServices) {
            ControllerServiceState existingState = this.controllerServiceStates.get(service.getIdentifier());
            if (existingState == null) {
                logger.debug("Will not enable {} because it was not previously known in this Process Group", (Object)service);
                continue;
            }
            if (existingState != ControllerServiceState.ENABLED && existingState != ControllerServiceState.ENABLING) {
                logger.debug("Will not enable {} because its previously state was {}", (Object)service, (Object)existingState);
                continue;
            }
            toEnable.add(service);
        }
        logger.debug("Enabling {}", toEnable);
        this.delegate.enableControllerServicesAsync(toEnable);
    }

    public void disableControllerServicesAsync(Collection<ControllerServiceNode> controllerServices) {
        this.delegate.disableControllerServicesAsync(controllerServices);
    }

    public void startReportingTask(ReportingTaskNode reportingTask) {
        this.delegate.startReportingTask(reportingTask);
    }

    public void pause() {
        this.delegate.pause();
    }

    public void resume() {
        this.delegate.resume();
    }

    private Map<String, ControllerServiceState> mapControllerServiceStates(ProcessGroup group) {
        Set services = group.findAllControllerServices();
        Map<String, ControllerServiceState> serviceStates = services.stream().collect(Collectors.toMap(ComponentNode::getIdentifier, ControllerServiceNode::getState));
        return serviceStates;
    }

    private Map<String, org.apache.nifi.controller.ScheduledState> mapComponentStates(ProcessGroup group) {
        HashSet<Connectable> connectables = new HashSet<Connectable>();
        this.findAllConnectables(group, connectables);
        HashMap<String, org.apache.nifi.controller.ScheduledState> componentStates = new HashMap<String, org.apache.nifi.controller.ScheduledState>();
        for (Connectable connectable : connectables) {
            componentStates.put(connectable.getIdentifier(), connectable.getScheduledState());
        }
        HashSet<ProcessGroup> statelessGroups = new HashSet<ProcessGroup>();
        this.findAllStatelessGroups(group, statelessGroups);
        for (ProcessGroup statelessGroup : statelessGroups) {
            StatelessGroupScheduledState state = statelessGroup.getStatelessScheduledState();
            org.apache.nifi.controller.ScheduledState scheduledState = state == StatelessGroupScheduledState.RUNNING ? org.apache.nifi.controller.ScheduledState.RUNNING : org.apache.nifi.controller.ScheduledState.STOPPED;
            componentStates.put(statelessGroup.getIdentifier(), scheduledState);
        }
        return componentStates;
    }

    private void findAllConnectables(ProcessGroup group, Set<Connectable> connectables) {
        connectables.addAll(group.getInputPorts());
        connectables.addAll(group.getOutputPorts());
        connectables.addAll(group.getFunnels());
        connectables.addAll(group.getProcessors());
        for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
            connectables.addAll(remoteGroup.getInputPorts());
            connectables.addAll(remoteGroup.getOutputPorts());
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            this.findAllConnectables(childGroup, connectables);
        }
    }

    private void findAllStatelessGroups(ProcessGroup start, Set<ProcessGroup> statelessGroups) {
        if (start.resolveExecutionEngine() == ExecutionEngine.STATELESS) {
            statelessGroups.add(start);
            return;
        }
        for (ProcessGroup childGroup : start.getProcessGroups()) {
            this.findAllStatelessGroups(childGroup, statelessGroups);
        }
    }
}

