/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;

public class PerformanceTrackingInputStream
extends FilterInputStream {
    private final PerformanceTracker performanceTracker;

    public PerformanceTrackingInputStream(InputStream in, PerformanceTracker performanceTracker) {
        super(in);
        this.performanceTracker = performanceTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        this.performanceTracker.beginContentRead();
        try {
            long l = super.skip(n);
            return l;
        }
        finally {
            this.performanceTracker.endContentRead();
        }
    }

    @Override
    public int read() throws IOException {
        this.performanceTracker.beginContentRead();
        try {
            int n = super.read();
            return n;
        }
        finally {
            this.performanceTracker.endContentRead();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.performanceTracker.beginContentRead();
        try {
            int n = super.read(b, off, len);
            return n;
        }
        finally {
            this.performanceTracker.endContentRead();
        }
    }
}

