/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import org.apache.nifi.controller.repository.metrics.PerformanceTracker;

public class NanoTimePerformanceTracker
implements PerformanceTracker {
    private final Timer contentReadTimer = new Timer();
    private final Timer contentWriteTimer = new Timer();
    private final Timer sessionCommitTimer = new Timer();
    private int writeDepth = 0;

    @Override
    public void beginContentRead() {
        this.contentReadTimer.start();
    }

    @Override
    public void endContentRead() {
        this.contentReadTimer.stop();
    }

    @Override
    public long getContentReadNanos() {
        return this.contentReadTimer.get();
    }

    @Override
    public void beginContentWrite() {
        ++this.writeDepth;
        if (this.writeDepth == 1) {
            this.contentWriteTimer.start();
        }
    }

    @Override
    public void endContentWrite() {
        --this.writeDepth;
        if (this.writeDepth == 0) {
            this.contentWriteTimer.stop();
        }
    }

    @Override
    public long getContentWriteNanos() {
        return this.contentWriteTimer.get();
    }

    @Override
    public void beginSessionCommit() {
        this.sessionCommitTimer.start();
    }

    @Override
    public void endSessionCommit() {
        this.sessionCommitTimer.stop();
    }

    @Override
    public long getSessionCommitNanos() {
        return this.sessionCommitTimer.get();
    }

    private static class Timer {
        private long start = -1L;
        private long total;

        private Timer() {
        }

        public void start() {
            this.start = System.nanoTime();
        }

        public void stop() {
            if (this.start == -1L) {
                return;
            }
            this.total += System.nanoTime() - this.start;
            this.start = -1L;
        }

        public long get() {
            return this.total;
        }
    }
}

