/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.flowanalysis.FlowAnalyzer;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flowanalysis.EnforcementPolicy;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterUpdate;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBranch;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.FlowRegistryClientUserContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowRegistryPreCommitException;
import org.apache.nifi.registry.flow.FlowSnapshotContainer;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisterAction;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.validation.RuleViolation;
import org.apache.nifi.validation.RuleViolationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowAnalyzingRegistryClientNode
implements FlowRegistryClientNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowAnalyzingRegistryClientNode.class);
    private final FlowRegistryClientNode node;
    private final ControllerServiceProvider serviceProvider;
    private final FlowAnalyzer flowAnalyzer;
    private final RuleViolationsManager ruleViolationsManager;
    private final FlowManager flowManager;
    private final NiFiRegistryFlowMapper flowMapper;

    public FlowAnalyzingRegistryClientNode(FlowRegistryClientNode node, ControllerServiceProvider serviceProvider, FlowAnalyzer flowAnalyzer, RuleViolationsManager ruleViolationsManager, FlowManager flowManager, NiFiRegistryFlowMapper flowMapper) {
        this.node = Objects.requireNonNull(node);
        this.serviceProvider = Objects.requireNonNull(serviceProvider);
        this.flowAnalyzer = Objects.requireNonNull(flowAnalyzer);
        this.ruleViolationsManager = Objects.requireNonNull(ruleViolationsManager);
        this.flowManager = Objects.requireNonNull(flowManager);
        this.flowMapper = Objects.requireNonNull(flowMapper);
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientUserContext context, RegisteredFlow flow, VersionedProcessGroup snapshot, Map<String, ExternalControllerServiceReference> externalControllerServices, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, String comments, String expectedVersion, RegisterAction registerAction) throws FlowRegistryException, IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Snapshot for flow {} is checked for violations before commit", (Object)snapshot.getInstanceIdentifier());
        }
        if (this.analyzeProcessGroupToRegister(snapshot)) {
            return this.node.registerFlowSnapshot(context, flow, snapshot, externalControllerServices, parameterContexts, parameterProviderReferences, comments, expectedVersion, registerAction);
        }
        throw new FlowRegistryPreCommitException("There are unresolved rule violations");
    }

    private boolean analyzeProcessGroupToRegister(VersionedProcessGroup snapshot) {
        InstantiatedVersionedProcessGroup nonVersionedProcessGroup = this.flowMapper.mapNonVersionedProcessGroup(this.flowManager.getGroup(snapshot.getInstanceIdentifier()), this.serviceProvider);
        this.flowAnalyzer.analyzeProcessGroup((VersionedProcessGroup)nonVersionedProcessGroup);
        List<RuleViolation> ruleViolations = this.ruleViolationsManager.getRuleViolationsForGroup(snapshot.getInstanceIdentifier()).stream().filter(ruleViolation -> EnforcementPolicy.ENFORCE.equals((Object)ruleViolation.getEnforcementPolicy())).toList();
        boolean result = ruleViolations.isEmpty();
        if (LOGGER.isDebugEnabled()) {
            String violations = ruleViolations.stream().map(RuleViolation::getViolationMessage).collect(Collectors.joining(", "));
            LOGGER.debug("Snapshot for {} has following violation(s): {}", (Object)snapshot.getInstanceIdentifier(), (Object)violations);
        }
        return result;
    }

    public Authorizable getParentAuthorizable() {
        return this.node.getParentAuthorizable();
    }

    public Resource getResource() {
        return this.node.getResource();
    }

    public String getProcessGroupIdentifier() {
        return this.node.getProcessGroupIdentifier();
    }

    public String getIdentifier() {
        return this.node.getIdentifier();
    }

    public String getName() {
        return this.node.getName();
    }

    public void setName(String name) {
        this.node.setName(name);
    }

    public String getAnnotationData() {
        return this.node.getAnnotationData();
    }

    public void setAnnotationData(String data) {
        this.node.setAnnotationData(data);
    }

    public void setProperties(Map<String, String> properties, boolean allowRemovalOfRequiresProperties, Set<String> sensitiveDynamicPropertyNames) {
        this.node.setProperties(properties, allowRemovalOfRequiresProperties, sensitiveDynamicPropertyNames);
    }

    public void verifyCanUpdateProperties(Map<String, String> properties) {
        this.node.verifyCanUpdateProperties(properties);
    }

    public Set<String> getReferencedParameterNames() {
        return this.node.getReferencedParameterNames();
    }

    public boolean isReferencingParameter() {
        return this.node.isReferencingParameter();
    }

    public boolean isReferencingParameter(String parameterName) {
        return this.node.isReferencingParameter(parameterName);
    }

    public void onParametersModified(Map<String, ParameterUpdate> parameterUpdates) {
        this.node.onParametersModified(parameterUpdates);
    }

    public Set<String> getReferencedAttributeNames() {
        return this.node.getReferencedAttributeNames();
    }

    public void pauseValidationTrigger() {
        this.node.pauseValidationTrigger();
    }

    public void resumeValidationTrigger() {
        this.node.resumeValidationTrigger();
    }

    public Map<PropertyDescriptor, String> getRawPropertyValues() {
        return this.node.getRawPropertyValues();
    }

    public Map<PropertyDescriptor, String> getEffectivePropertyValues() {
        return this.node.getEffectivePropertyValues();
    }

    public PropertyConfiguration getProperty(PropertyDescriptor property) {
        return this.node.getProperty(property);
    }

    public String getEffectivePropertyValue(PropertyDescriptor property) {
        return this.node.getEffectivePropertyValue(property);
    }

    public String getRawPropertyValue(PropertyDescriptor property) {
        return this.node.getRawPropertyValue(property);
    }

    public Map<PropertyDescriptor, PropertyConfiguration> getProperties() {
        return this.node.getProperties();
    }

    public void reload(Set<URL> additionalUrls) throws Exception {
        this.node.reload(additionalUrls);
    }

    public void refreshProperties() {
        this.node.refreshProperties();
    }

    public Set<URL> getAdditionalClasspathResources(List<PropertyDescriptor> propertyDescriptors) {
        return this.node.getAdditionalClasspathResources(propertyDescriptors);
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.node.getBundleCoordinate();
    }

    public ConfigurableComponent getComponent() {
        return this.node.getComponent();
    }

    public TerminationAwareLogger getLogger() {
        return this.node.getLogger();
    }

    public boolean isExtensionMissing() {
        return this.node.isExtensionMissing();
    }

    public void setExtensionMissing(boolean extensionMissing) {
        this.node.setExtensionMissing(extensionMissing);
    }

    public void verifyCanUpdateBundle(BundleCoordinate bundleCoordinate) throws IllegalStateException {
        this.node.verifyCanUpdateBundle(bundleCoordinate);
    }

    public boolean isReloadAdditionalResourcesNecessary() {
        return this.node.isReloadAdditionalResourcesNecessary();
    }

    public void reloadAdditionalResourcesIfNecessary() {
        this.node.reloadAdditionalResourcesIfNecessary();
    }

    public void resetValidationState() {
        this.node.resetValidationState();
    }

    public Collection<ValidationResult> getValidationErrors() {
        return this.node.getValidationErrors();
    }

    public String getComponentType() {
        return this.node.getComponentType();
    }

    public Class<?> getComponentClass() {
        return this.node.getComponentClass();
    }

    public String getCanonicalClassName() {
        return this.node.getCanonicalClassName();
    }

    public boolean isRestricted() {
        return this.node.isRestricted();
    }

    public boolean isDeprecated() {
        return this.node.isDeprecated();
    }

    public boolean isValidationNecessary() {
        return this.node.isValidationNecessary();
    }

    public ValidationStatus getValidationStatus() {
        return this.node.getValidationStatus();
    }

    public ValidationStatus getValidationStatus(long timeout, TimeUnit unit) {
        return this.node.getValidationStatus(timeout, unit);
    }

    public ValidationStatus performValidation() {
        return this.node.performValidation();
    }

    public ValidationState performValidation(ValidationContext validationContext) {
        return this.node.performValidation(validationContext);
    }

    public ValidationState performValidation(Map<PropertyDescriptor, PropertyConfiguration> properties, String annotationData, ParameterContext parameterContext) {
        return this.node.performValidation(properties, annotationData, parameterContext);
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return this.node.getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.node.getPropertyDescriptor(name);
    }

    public boolean isSensitiveDynamicProperty(String name) {
        return this.node.isSensitiveDynamicProperty(name);
    }

    public Optional<ProcessGroup> getParentProcessGroup() {
        return this.node.getParentProcessGroup();
    }

    public ParameterLookup getParameterLookup() {
        return this.node.getParameterLookup();
    }

    public String getDescription() {
        return this.node.getDescription();
    }

    public void setDescription(String description) {
        this.node.setDescription(description);
    }

    public boolean isStorageLocationApplicable(String location) {
        return this.node.isStorageLocationApplicable(location);
    }

    public boolean isBranchingSupported() {
        return this.node.isBranchingSupported();
    }

    public Set<FlowRegistryBranch> getBranches(FlowRegistryClientUserContext context) throws FlowRegistryException, IOException {
        return this.node.getBranches(context);
    }

    public FlowRegistryBranch getDefaultBranch(FlowRegistryClientUserContext context) throws FlowRegistryException, IOException {
        return this.node.getDefaultBranch(context);
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientUserContext context, String branch) throws FlowRegistryException, IOException {
        return this.node.getBuckets(context, branch);
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientUserContext context, BucketLocation bucketLocation) throws FlowRegistryException, IOException {
        return this.node.getBucket(context, bucketLocation);
    }

    public RegisteredFlow registerFlow(FlowRegistryClientUserContext context, RegisteredFlow flow) throws FlowRegistryException, IOException {
        return this.node.registerFlow(context, flow);
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.node.deregisterFlow(context, flowLocation);
    }

    public RegisteredFlow getFlow(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.node.getFlow(context, flowLocation);
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientUserContext context, BucketLocation bucketLocation) throws FlowRegistryException, IOException {
        return this.node.getFlows(context, bucketLocation);
    }

    public FlowSnapshotContainer getFlowContents(FlowRegistryClientUserContext context, FlowVersionLocation flowVersionLocation, boolean fetchRemoteFlows) throws FlowRegistryException, IOException {
        return this.node.getFlowContents(context, flowVersionLocation, fetchRemoteFlows);
    }

    public List<ConfigVerificationResult> verifyConfiguration(Map<String, String> properties, Map<String, String> variables, ComponentLog logger, ExtensionManager extensionManager) {
        return this.node.verifyConfiguration(properties, variables, logger, extensionManager);
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.node.getFlowVersions(context, flowLocation);
    }

    public Optional<String> getLatestVersion(FlowRegistryClientUserContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        return this.node.getLatestVersion(context, flowLocation);
    }

    public String generateFlowId(String flowName) throws IOException, FlowRegistryException {
        return this.node.generateFlowId(flowName);
    }

    public void setComponent(LoggableComponent<FlowRegistryClient> component) {
        this.node.setComponent(component);
    }
}

