/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.synchronization;

import java.util.Objects;
import java.util.function.Function;
import org.apache.nifi.asset.AssetManager;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.ComponentIdGenerator;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;

public class VersionedFlowSynchronizationContext {
    private final ComponentIdGenerator componentIdGenerator;
    private final FlowManager flowManager;
    private final ReloadComponent reloadComponent;
    private final ControllerServiceProvider controllerServiceProvider;
    private final ExtensionManager extensionManager;
    private final ComponentScheduler componentScheduler;
    private final FlowMappingOptions flowMappingOptions;
    private final Function<ProcessorNode, ProcessContext> processContextFactory;
    private final Function<ComponentNode, ConfigurationContext> configurationContextFactory;
    private final AssetManager assetManager;

    private VersionedFlowSynchronizationContext(Builder builder) {
        this.componentIdGenerator = builder.componentIdGenerator;
        this.flowManager = builder.flowManager;
        this.reloadComponent = builder.reloadComponent;
        this.controllerServiceProvider = builder.controllerServiceProvider;
        this.extensionManager = builder.extensionManager;
        this.componentScheduler = builder.componentScheduler;
        this.flowMappingOptions = builder.flowMappingOptions;
        this.processContextFactory = builder.processContextFactory;
        this.configurationContextFactory = builder.configurationContextFactory;
        this.assetManager = builder.assetManager;
    }

    public ComponentIdGenerator getComponentIdGenerator() {
        return this.componentIdGenerator;
    }

    public FlowManager getFlowManager() {
        return this.flowManager;
    }

    public ReloadComponent getReloadComponent() {
        return this.reloadComponent;
    }

    public ControllerServiceProvider getControllerServiceProvider() {
        return this.controllerServiceProvider;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public ComponentScheduler getComponentScheduler() {
        return this.componentScheduler;
    }

    public FlowMappingOptions getFlowMappingOptions() {
        return this.flowMappingOptions;
    }

    public Function<ProcessorNode, ProcessContext> getProcessContextFactory() {
        return this.processContextFactory;
    }

    public Function<ComponentNode, ConfigurationContext> getConfigurationContextFactory() {
        return this.configurationContextFactory;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public static class Builder {
        private ComponentIdGenerator componentIdGenerator;
        private FlowManager flowManager;
        private ReloadComponent reloadComponent;
        private ControllerServiceProvider controllerServiceProvider;
        private ExtensionManager extensionManager;
        private ComponentScheduler componentScheduler;
        private FlowMappingOptions flowMappingOptions;
        private Function<ProcessorNode, ProcessContext> processContextFactory;
        private Function<ComponentNode, ConfigurationContext> configurationContextFactory;
        private AssetManager assetManager;

        public Builder componentIdGenerator(ComponentIdGenerator componentIdGenerator) {
            this.componentIdGenerator = componentIdGenerator;
            return this;
        }

        public Builder flowManager(FlowManager flowManager) {
            this.flowManager = flowManager;
            return this;
        }

        public Builder reloadComponent(ReloadComponent reloadComponent) {
            this.reloadComponent = reloadComponent;
            return this;
        }

        public Builder controllerServiceProvider(ControllerServiceProvider provider) {
            this.controllerServiceProvider = provider;
            return this;
        }

        public Builder extensionManager(ExtensionManager extensionManager) {
            this.extensionManager = extensionManager;
            return this;
        }

        public Builder componentScheduler(ComponentScheduler scheduler) {
            this.componentScheduler = scheduler;
            return this;
        }

        public Builder flowMappingOptions(FlowMappingOptions flowMappingOptions) {
            this.flowMappingOptions = flowMappingOptions;
            return this;
        }

        public Builder processContextFactory(Function<ProcessorNode, ProcessContext> processContextFactory) {
            this.processContextFactory = processContextFactory;
            return this;
        }

        public Builder configurationContextFactory(Function<ComponentNode, ConfigurationContext> configurationContextFactory) {
            this.configurationContextFactory = configurationContextFactory;
            return this;
        }

        public Builder assetManager(AssetManager assetManager) {
            this.assetManager = assetManager;
            return this;
        }

        public VersionedFlowSynchronizationContext build() {
            Objects.requireNonNull(this.componentIdGenerator, "Component ID Generator must be set");
            Objects.requireNonNull(this.flowManager, "Flow Manager must be set");
            Objects.requireNonNull(this.reloadComponent, "Reload Component must be set");
            Objects.requireNonNull(this.controllerServiceProvider, "Controller Service Provider must be set");
            Objects.requireNonNull(this.extensionManager, "Extension Manager must be set");
            Objects.requireNonNull(this.componentScheduler, "Component Scheduler must be set");
            Objects.requireNonNull(this.flowMappingOptions, "Flow Mapping Options must be set");
            Objects.requireNonNull(this.processContextFactory, "Process Context Factory must be set");
            Objects.requireNonNull(this.configurationContextFactory, "Configuration Context Factory must be set");
            if (this.flowMappingOptions.isMapAssetReferences() && this.assetManager == null) {
                throw new IllegalStateException("Asset Manager must be set when Flow Mapping Options specified that Asset references must be mapped");
            }
            return new VersionedFlowSynchronizationContext(this);
        }
    }
}

