/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.validation;

import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.ComponentNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardValidationTrigger
implements ValidationTrigger {
    private static final Logger logger = LoggerFactory.getLogger(StandardValidationTrigger.class);
    private final ExecutorService threadPool;
    private final BooleanSupplier flowInitialized;

    public StandardValidationTrigger(ExecutorService threadPool, BooleanSupplier flowInitialized) {
        this.threadPool = threadPool;
        this.flowInitialized = flowInitialized;
    }

    public void triggerAsync(ComponentNode component) {
        if (!this.flowInitialized.getAsBoolean()) {
            logger.debug("Triggered to perform validation on {} asynchronously but flow is not yet initialized so will ignore validation", (Object)component);
            return;
        }
        this.threadPool.submit(() -> this.trigger(component));
    }

    public void trigger(ComponentNode component) {
        try {
            if (component.isValidationNecessary()) {
                component.performValidation();
            }
        }
        catch (Throwable t) {
            component.getLogger().error("Failed to perform validation", t);
        }
    }
}

