/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;

public class ConnectableLogObserver
implements LogObserver {
    private static final String CATEGORY = "Log Message";
    private final BulletinRepository bulletinRepository;
    private final Connectable connectable;

    public ConnectableLogObserver(BulletinRepository bulletinRepository, Connectable connectable) {
        this.bulletinRepository = bulletinRepository;
        this.connectable = connectable;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLogLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLogLevel().toString();
        this.bulletinRepository.addBulletin(BulletinFactory.createBulletin((Connectable)this.connectable, (String)CATEGORY, (String)bulletinLevel, (String)message.getMessage(), (String)message.getFlowFileUuid()));
    }

    public String getComponentDescription() {
        return this.connectable.toString();
    }
}

