/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.processor.SimpleProcessLogger;

public class StandardStateManager
implements StateManager {
    private final StateProvider localProvider;
    private final StateProvider clusterProvider;
    private final String componentId;
    private final Supplier<Boolean> dropStateKeySupportedSupplier;

    public StandardStateManager(StateProvider localProvider, StateProvider clusterProvider, String componentId) {
        this(localProvider, clusterProvider, componentId, () -> false);
    }

    public StandardStateManager(StateProvider localProvider, StateProvider clusterProvider, String componentId, Supplier<Boolean> dropStateKeySupportedSupplier) {
        this.localProvider = localProvider;
        this.clusterProvider = clusterProvider;
        this.componentId = componentId;
        this.dropStateKeySupportedSupplier = dropStateKeySupportedSupplier;
    }

    private StateProvider getProvider(Scope scope) {
        if (scope == Scope.LOCAL || this.clusterProvider == null || !this.clusterProvider.isEnabled()) {
            return this.localProvider;
        }
        return this.clusterProvider;
    }

    private ComponentLog getLogger(String componentId) {
        ComponentLog logger;
        LogRepository repo = LogRepositoryFactory.getRepository((String)componentId);
        ComponentLog componentLog = logger = repo == null ? null : repo.getLogger();
        if (repo == null || logger == null) {
            return new SimpleProcessLogger(componentId, this, (LoggingContext)new StandardLoggingContext(null));
        }
        return logger;
    }

    public StateMap getState(Scope scope) throws IOException {
        StateMap stateMap = this.getProvider(scope).getState(this.componentId);
        this.getLogger(this.componentId).debug("Returning {} State: {}", new Object[]{scope, stateMap});
        return stateMap;
    }

    public boolean replace(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        boolean replaced = this.getProvider(scope).replace(oldValue, newValue, this.componentId);
        this.getLogger(this.componentId).debug("{} State from old value {} to new value {} was {}", new Object[]{scope, oldValue, newValue, replaced});
        return replaced;
    }

    public void setState(Map<String, String> state, Scope scope) throws IOException {
        this.getLogger(this.componentId).debug("Setting {} State to {}", new Object[]{scope, state});
        this.getProvider(scope).setState(state, this.componentId);
    }

    public void clear(Scope scope) throws IOException {
        this.getLogger(this.componentId).debug("Clearing {} State", new Object[]{scope});
        this.getProvider(scope).clear(this.componentId);
    }

    public boolean isStateKeyDropSupported() {
        return this.dropStateKeySupportedSupplier.get();
    }

    public String toString() {
        return "StandardStateManager[componentId=" + this.componentId + "]";
    }
}

