/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.UsersEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UsersEntity;

public class UsersEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern TENANTS_URI_PATTERN = Pattern.compile("/nifi-api/tenants/users");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && TENANTS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        UsersEntity responseEntity = (UsersEntity)clientResponse.getClientResponse().readEntity(UsersEntity.class);
        Collection userEntities = responseEntity.getUsers();
        HashMap<String, Map<NodeIdentifier, UserEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, UserEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            UsersEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (UsersEntity)nodeResponse.getClientResponse().readEntity(UsersEntity.class);
            Collection nodeUserEntities = nodeResponseEntity.getUsers();
            userEntities.retainAll(nodeUserEntities);
            for (UserEntity nodeUserEntity : nodeUserEntities) {
                Map innerMap = entityMap.computeIfAbsent(nodeUserEntity.getId(), k -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodeUserEntity);
            }
        }
        UsersEntityMerger.mergeUsers(userEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

