/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.ReportingTasksEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;

public class ReportingTasksEndpointMerger
implements EndpointResponseMerger {
    public static final String REPORTING_TASKS_URI = "/nifi-api/flow/reporting-tasks";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && REPORTING_TASKS_URI.equals(uri.getPath());
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        ReportingTasksEntity responseEntity = (ReportingTasksEntity)clientResponse.getClientResponse().readEntity(ReportingTasksEntity.class);
        Set reportingTasksEntities = responseEntity.getReportingTasks();
        HashMap<String, Map<NodeIdentifier, ReportingTaskEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, ReportingTaskEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ReportingTasksEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ReportingTasksEntity)nodeResponse.getClientResponse().readEntity(ReportingTasksEntity.class);
            Set nodeReportingTaskEntities = nodeResponseEntity.getReportingTasks();
            for (ReportingTaskEntity nodeReportingTaskEntity : nodeReportingTaskEntities) {
                Map innerMap = entityMap.computeIfAbsent(nodeReportingTaskEntity.getId(), k -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodeReportingTaskEntity);
            }
        }
        ReportingTasksEntityMerger.mergeReportingTasks(reportingTasksEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

