/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.entity.ProvenanceEventEntity;

public class ProvenanceEventEndpointMerger
extends AbstractSingleDTOEndpoint<ProvenanceEventEntity, ProvenanceEventDTO> {
    public static final Pattern PROVENANCE_EVENT_URI = Pattern.compile("/nifi-api/provenance/events/[0-9]+");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROVENANCE_EVENT_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ProvenanceEventEntity> getEntityClass() {
        return ProvenanceEventEntity.class;
    }

    @Override
    protected ProvenanceEventDTO getDto(ProvenanceEventEntity entity) {
        return entity.getProvenanceEvent();
    }

    @Override
    protected void mergeResponses(ProvenanceEventDTO clientDto, Map<NodeIdentifier, ProvenanceEventDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        if (clientDto.getClusterNodeId() == null || clientDto.getClusterNodeAddress() == null) {
            NodeIdentifier nodeId = successfulResponses.iterator().next().getNodeId();
            clientDto.setClusterNodeId(nodeId.getId());
            clientDto.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
    }
}

