/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.entity.NarDetailsEntity;

public class NarDetailsEndpointMerger
extends AbstractSingleEntityEndpoint<NarDetailsEntity> {
    public static final Pattern NAR_DETAILS_URI_PATTERN = Pattern.compile("/nifi-api/controller/nar-manager/nars/[a-f0-9\\-]{36}/details");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equals(method) && NAR_DETAILS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<NarDetailsEntity> getEntityClass() {
        return NarDetailsEntity.class;
    }

    @Override
    protected void mergeResponses(NarDetailsEntity clientEntity, Map<NodeIdentifier, NarDetailsEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        for (Map.Entry<NodeIdentifier, NarDetailsEntity> entry : entityMap.entrySet()) {
            NarDetailsEntity nodeEntity = entry.getValue();
            this.merge(clientEntity.getProcessorTypes(), nodeEntity.getProcessorTypes());
            this.merge(clientEntity.getControllerServiceTypes(), nodeEntity.getControllerServiceTypes());
            this.merge(clientEntity.getReportingTaskTypes(), nodeEntity.getReportingTaskTypes());
            this.merge(clientEntity.getParameterProviderTypes(), nodeEntity.getParameterProviderTypes());
            this.merge(clientEntity.getFlowRegistryClientTypes(), nodeEntity.getFlowRegistryClientTypes());
            this.merge(clientEntity.getFlowAnalysisRuleTypes(), nodeEntity.getFlowAnalysisRuleTypes());
        }
    }

    private void merge(Set<DocumentedTypeDTO> clientTypes, Set<DocumentedTypeDTO> nodeTypes) {
        if (clientTypes == null || nodeTypes == null) {
            return;
        }
        clientTypes.retainAll(nodeTypes);
    }
}

