/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.state.SortedStateUtils;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.StateEntryDTO;
import org.apache.nifi.web.api.dto.StateMapDTO;
import org.apache.nifi.web.api.entity.ComponentStateEntity;

public class ComponentStateEndpointMerger
extends AbstractSingleDTOEndpoint<ComponentStateEntity, ComponentStateDTO> {
    public static final Pattern PROCESSOR_STATE_URI_PATTERN = Pattern.compile("/nifi-api/processors/[a-f0-9\\-]{36}/state");
    public static final Pattern CONTROLLER_SERVICE_STATE_URI_PATTERN = Pattern.compile("/nifi-api/controller-services/[a-f0-9\\-]{36}/state");
    public static final Pattern REPORTING_TASK_STATE_URI_PATTERN = Pattern.compile("/nifi-api/reporting-tasks/[a-f0-9\\-]{36}/state");
    public static final Pattern FLOW_ANALYSIS_RULE_STATE_URI_PATTERN = Pattern.compile("/nifi-api/controller/flow-analysis-rules/[a-f0-9\\-]{36}/state");

    @Override
    public boolean canHandle(URI uri, String method) {
        if (!"GET".equalsIgnoreCase(method)) {
            return false;
        }
        return PROCESSOR_STATE_URI_PATTERN.matcher(uri.getPath()).matches() || CONTROLLER_SERVICE_STATE_URI_PATTERN.matcher(uri.getPath()).matches() || REPORTING_TASK_STATE_URI_PATTERN.matcher(uri.getPath()).matches() || FLOW_ANALYSIS_RULE_STATE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ComponentStateEntity> getEntityClass() {
        return ComponentStateEntity.class;
    }

    @Override
    protected ComponentStateDTO getDto(ComponentStateEntity entity) {
        return entity.getComponentState();
    }

    @Override
    protected void mergeResponses(ComponentStateDTO clientDto, Map<NodeIdentifier, ComponentStateDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        List<StateEntryDTO> localStateEntries = new ArrayList();
        int totalStateEntries = 0;
        for (Map.Entry<NodeIdentifier, ComponentStateDTO> nodeEntry : dtoMap.entrySet()) {
            ComponentStateDTO nodeComponentState = nodeEntry.getValue();
            NodeIdentifier nodeId = nodeEntry.getKey();
            String nodeAddress = nodeId.getApiAddress() + ":" + nodeId.getApiPort();
            StateMapDTO nodeLocalStateMap = nodeComponentState.getLocalState();
            if (nodeLocalStateMap.getState() == null) continue;
            totalStateEntries += nodeLocalStateMap.getTotalEntryCount();
            for (StateEntryDTO nodeStateEntry : nodeLocalStateMap.getState()) {
                if (nodeStateEntry.getClusterNodeId() == null || nodeStateEntry.getClusterNodeAddress() == null) {
                    nodeStateEntry.setClusterNodeId(nodeId.getId());
                    nodeStateEntry.setClusterNodeAddress(nodeAddress);
                }
                localStateEntries.add(nodeStateEntry);
            }
        }
        Collections.sort(localStateEntries, SortedStateUtils.getEntryDtoComparator());
        if (localStateEntries.size() > 5000) {
            localStateEntries = localStateEntries.subList(0, 5000);
        }
        clientDto.getLocalState().setTotalEntryCount(totalStateEntries);
        clientDto.getLocalState().setState(localStateEntries);
    }
}

