/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.BulletinMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ClearBulletinsResultEntity;

public class ClearBulletinsEndpointMerger
extends AbstractSingleEntityEndpoint<ClearBulletinsResultEntity> {
    public static final Pattern CLEAR_BULLETINS_URI_PATTERN = Pattern.compile("/nifi-api/(?:processors|controller-services|reporting-tasks|parameter-providers|registry-clients|flow-analysis-rules|remote-process-groups)/[a-f0-9\\-]{36}/bulletins");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "POST".equalsIgnoreCase(method) && CLEAR_BULLETINS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ClearBulletinsResultEntity> getEntityClass() {
        return ClearBulletinsResultEntity.class;
    }

    @Override
    protected void mergeResponses(ClearBulletinsResultEntity clientEntity, Map<NodeIdentifier, ClearBulletinsResultEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        int totalBulletinsCleared = 0;
        for (ClearBulletinsResultEntity clearBulletinsResultEntity : entityMap.values()) {
            totalBulletinsCleared += clearBulletinsResultEntity.getBulletinsCleared();
        }
        clientEntity.setBulletinsCleared(totalBulletinsCleared);
        HashMap<NodeIdentifier, List<BulletinEntity>> bulletinMap = new HashMap<NodeIdentifier, List<BulletinEntity>>();
        for (Map.Entry<NodeIdentifier, ClearBulletinsResultEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            ClearBulletinsResultEntity entity = entry.getValue();
            String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
            if (entity.getBulletins() == null) continue;
            ArrayList<BulletinEntity> nodeBulletins = new ArrayList<BulletinEntity>();
            for (BulletinEntity bulletinEntity : entity.getBulletins()) {
                if (bulletinEntity.getNodeAddress() == null) {
                    bulletinEntity.setNodeAddress(nodeAddress);
                }
                if (bulletinEntity.getCanRead().booleanValue() && bulletinEntity.getBulletin() != null && bulletinEntity.getBulletin().getNodeAddress() == null) {
                    bulletinEntity.getBulletin().setNodeAddress(nodeAddress);
                }
                nodeBulletins.add(bulletinEntity);
            }
            bulletinMap.put(nodeIdentifier, nodeBulletins);
        }
        List<BulletinEntity> list = BulletinMerger.mergeBulletins(bulletinMap, entityMap.size());
        clientEntity.setBulletins(list);
    }
}

