/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster;

import org.apache.nifi.cluster.ClusterDetailsFactory;
import org.apache.nifi.cluster.ConnectionState;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardClusterDetailsFactory
implements ClusterDetailsFactory {
    private static final Logger logger = LoggerFactory.getLogger(StandardClusterDetailsFactory.class);
    private final ClusterCoordinator clusterCoordinator;

    public StandardClusterDetailsFactory(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    public ConnectionState getConnectionState() {
        NodeConnectionStatus connectionStatus;
        if (this.clusterCoordinator == null) {
            logger.debug("No Cluster Coordinator has been configured; returning Connection State of NOT_CLUSTERED");
            return ConnectionState.NOT_CLUSTERED;
        }
        NodeIdentifier nodeIdentifier = this.clusterCoordinator.getLocalNodeIdentifier();
        if (nodeIdentifier == null) {
            logger.info("Local Node Identifier has not yet been established; returning Connection State of UNKNOWN");
            return ConnectionState.UNKNOWN;
        }
        if (this.clusterCoordinator.isActiveClusterCoordinator()) {
            logger.debug("Getting Connection Status for Node Identifier {} from local state", (Object)nodeIdentifier.getId());
            connectionStatus = this.clusterCoordinator.getConnectionStatus(nodeIdentifier);
        } else {
            NodeConnectionStatus fetchedConnectionStatus;
            logger.debug("Fetching Connection Status for Node Identifier {} from Cluster Coordinator", (Object)nodeIdentifier.getId());
            try {
                fetchedConnectionStatus = this.clusterCoordinator.fetchConnectionStatus(nodeIdentifier);
            }
            catch (Exception e) {
                logger.debug("Failed to fetch Connection Status for Node Identifier {} from Cluster Coordinator", (Object)nodeIdentifier.getId(), (Object)e);
                fetchedConnectionStatus = null;
            }
            if (fetchedConnectionStatus == null) {
                logger.debug("Fetched Connection Status for Node Identifier {} is null; falling back to local state", (Object)nodeIdentifier.getId());
                connectionStatus = this.clusterCoordinator.getConnectionStatus(nodeIdentifier);
            } else {
                connectionStatus = fetchedConnectionStatus;
            }
        }
        if (connectionStatus == null) {
            logger.info("Cluster connection status is not currently known for Node Identifier {}; returning Connection State of UNKNOWN", (Object)nodeIdentifier.getId());
            return ConnectionState.UNKNOWN;
        }
        String stateName = connectionStatus.getState().name();
        try {
            ConnectionState connectionState = ConnectionState.valueOf((String)stateName);
            logger.debug("Returning Connection State of {}", (Object)connectionState);
            return connectionState;
        }
        catch (IllegalArgumentException iae) {
            logger.warn("Cluster Coordinator reports Connection State of {}, which is not a known state; returning UNKNOWN", (Object)stateName);
            return ConnectionState.UNKNOWN;
        }
    }
}

