/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.RuntimeManifestEntity;

public class RuntimeManifestEndpointMerger
implements EndpointResponseMerger {
    public static final String RUNTIME_MANIFEST_URI_PATTERN = "/nifi-api/flow/runtime-manifest";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && RUNTIME_MANIFEST_URI_PATTERN.equals(uri.getPath());
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Merge of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        RuntimeManifestEntity responseEntity = (RuntimeManifestEntity)clientResponse.getClientResponse().readEntity(RuntimeManifestEntity.class);
        RuntimeManifest responseManifest = responseEntity.getRuntimeManifest();
        LinkedHashSet responseBundles = responseManifest.getBundles() == null ? new LinkedHashSet() : new LinkedHashSet(responseManifest.getBundles());
        for (NodeResponse nodeResponse : successfulResponses) {
            RuntimeManifestEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (RuntimeManifestEntity)nodeResponse.getClientResponse().readEntity(RuntimeManifestEntity.class);
            RuntimeManifest nodeResponseManifest = nodeResponseEntity.getRuntimeManifest();
            List nodeResponseBundles = nodeResponseManifest.getBundles() == null ? Collections.emptyList() : nodeResponseManifest.getBundles();
            responseBundles.retainAll(nodeResponseBundles);
        }
        responseManifest.setBundles(new ArrayList(responseBundles));
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

