/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class ParameterContextMerger {
    public static void merge(ParameterContextEntity target, Map<NodeIdentifier, ParameterContextEntity> entityMap) {
        HashMap<NodeIdentifier, ParameterContextDTO> dtoMap = new HashMap<NodeIdentifier, ParameterContextDTO>();
        for (Map.Entry<NodeIdentifier, ParameterContextEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ParameterContextEntity entity = entry.getValue();
            PermissionsDtoMerger.mergePermissions(target.getPermissions(), entity.getPermissions());
            if (entity.getComponent() == null) {
                target.setComponent(null);
                continue;
            }
            dtoMap.put(nodeId, entity.getComponent());
        }
        if (target.getComponent() != null) {
            ParameterContextMerger.merge(target.getComponent(), dtoMap);
        }
    }

    public static void merge(ParameterContextDTO target, Map<NodeIdentifier, ParameterContextDTO> entityMap) {
        HashMap<String, ProcessGroupEntity> mergedBoundGroups = new HashMap<String, ProcessGroupEntity>();
        HashMap<String, Map> affectedComponentsByParameterName = new HashMap<String, Map>();
        HashSet<String> unwritableParameters = new HashSet<String>();
        for (Map.Entry<NodeIdentifier, ParameterContextDTO> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ParameterContextDTO contextDto = entry.getValue();
            if (contextDto == null) continue;
            Set boundGroupEntities = contextDto.getBoundProcessGroups();
            if (boundGroupEntities != null) {
                for (ProcessGroupEntity groupEntity : boundGroupEntities) {
                    ProcessGroupEntity merged = (ProcessGroupEntity)mergedBoundGroups.get(groupEntity.getId());
                    if (merged == null) {
                        mergedBoundGroups.put(groupEntity.getId(), groupEntity);
                        continue;
                    }
                    ParameterContextMerger.merge(merged, nodeId, groupEntity);
                }
            }
            if (contextDto.getParameters() == null) continue;
            for (ParameterEntity parameterEntity : contextDto.getParameters()) {
                ParameterDTO parameterDto = parameterEntity.getParameter();
                if (!parameterEntity.getCanWrite().booleanValue()) {
                    unwritableParameters.add(parameterDto.getName());
                }
                Map affectedComponentsById = affectedComponentsByParameterName.computeIfAbsent(parameterDto.getName(), key -> new HashMap());
                for (AffectedComponentEntity referencingComponent : parameterDto.getReferencingComponents()) {
                    AffectedComponentEntity mergedAffectedComponent = (AffectedComponentEntity)affectedComponentsById.get(referencingComponent.getId());
                    if (mergedAffectedComponent == null) {
                        affectedComponentsById.put(referencingComponent.getId(), referencingComponent);
                        continue;
                    }
                    ParameterContextMerger.merge(mergedAffectedComponent, referencingComponent);
                }
            }
        }
        target.setBoundProcessGroups(new HashSet(mergedBoundGroups.values()));
        for (ParameterEntity parameterEntity : target.getParameters()) {
            ParameterDTO parameterDto = parameterEntity.getParameter();
            boolean unwritable = unwritableParameters.contains(parameterDto.getName());
            if (unwritable) {
                parameterEntity.setCanWrite(Boolean.valueOf(false));
            }
            Map componentMap = (Map)affectedComponentsByParameterName.get(parameterDto.getName());
            parameterDto.setReferencingComponents(new HashSet(componentMap.values()));
        }
    }

    private static void merge(ProcessGroupEntity merged, NodeIdentifier additionalNodeId, ProcessGroupEntity additional) {
        PermissionsDtoMerger.mergePermissions(merged.getPermissions(), additional.getPermissions());
        if (!Boolean.TRUE.equals(merged.getPermissions().getCanRead()) || additional.getComponent() == null) {
            merged.setComponent(null);
        }
        StatusMerger.merge(merged.getStatus(), (boolean)merged.getPermissions().getCanRead(), additional.getStatus(), (boolean)additional.getPermissions().getCanRead(), additionalNodeId.getId(), additionalNodeId.getApiAddress(), (Integer)additionalNodeId.getApiPort());
    }

    static void merge(AffectedComponentEntity merged, AffectedComponentEntity additional) {
        PermissionsDtoMerger.mergePermissions(merged.getPermissions(), additional.getPermissions());
        if (merged.getPermissions().getCanRead() == Boolean.TRUE) {
            List additionalBulletins = additional.getBulletins();
            if (additionalBulletins != null) {
                ArrayList mergedBulletins = merged.getBulletins();
                if (mergedBulletins == null) {
                    mergedBulletins = new ArrayList();
                    merged.setBulletins(mergedBulletins);
                }
                mergedBulletins.addAll(additionalBulletins);
            }
        } else {
            merged.setBulletins(null);
        }
        if (!Boolean.TRUE.equals(merged.getPermissions().getCanRead()) || additional.getComponent() == null) {
            merged.setComponent(null);
            return;
        }
        AffectedComponentDTO mergedComponent = merged.getComponent();
        AffectedComponentDTO additionalComponent = additional.getComponent();
        mergedComponent.setActiveThreadCount(ParameterContextMerger.add(mergedComponent.getActiveThreadCount(), additionalComponent.getActiveThreadCount()));
        if (mergedComponent.getValidationErrors() == null) {
            mergedComponent.setValidationErrors(new ArrayList());
        }
        if (additionalComponent.getValidationErrors() != null) {
            mergedComponent.getValidationErrors().addAll(additionalComponent.getValidationErrors());
        }
    }

    private static Integer add(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a + b;
    }
}

