/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NarSummaryDtoMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.NarSummaryDTO;
import org.apache.nifi.web.api.entity.NarSummaryEntity;

public class NarSummaryEndpointMerger
extends AbstractSingleDTOEndpoint<NarSummaryEntity, NarSummaryDTO> {
    private static final String NAR_MANAGER_PATH = "/nifi-api/controller/nar-manager";
    private static final String NAR_UPLOAD_PATH = "/nifi-api/controller/nar-manager/uploads";
    public static final Pattern NAR_URI_PATTERN = Pattern.compile("/nifi-api/controller/nar-manager/nars/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        if ("POST".equals(method) && NAR_UPLOAD_PATH.equals(uri.getPath())) {
            return true;
        }
        return ("DELETE".equals(method) || "GET".equals(method)) && NAR_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<NarSummaryEntity> getEntityClass() {
        return NarSummaryEntity.class;
    }

    @Override
    protected NarSummaryDTO getDto(NarSummaryEntity entity) {
        return entity.getNarSummary();
    }

    @Override
    protected void mergeResponses(NarSummaryDTO clientDto, Map<NodeIdentifier, NarSummaryDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        for (NarSummaryDTO nodeDto : dtoMap.values()) {
            NarSummaryDtoMerger.merge(clientDto, nodeDto);
        }
    }
}

